% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PWV1_static.R
\name{tab_similarity}
\alias{tab_similarity}
\alias{tab_similarity_cross}
\title{Tabulate cosine similarity/distance of word pairs.}
\usage{
tab_similarity(
  data,
  words = NULL,
  pattern = NULL,
  unique = FALSE,
  distance = FALSE
)

tab_similarity_cross(data, words1, words2, distance = FALSE)
}
\arguments{
\item{data}{A \code{\link[PsychWordVec:as_wordvec]{wordvec}} (data.table) or
\code{\link[PsychWordVec:as_embed]{embed}} (matrix),
see \code{\link{data_wordvec_load}}.}

\item{words}{[Option 1] Word strings (\code{NULL}; a single word; a vector of words).}

\item{pattern}{[Option 2] Pattern of regular expression (see \code{\link[stringr:str_subset]{str_subset}}).
If neither \code{words} nor \code{pattern} are specified (i.e., both are \code{NULL}),
then all words in the data will be extracted.}

\item{unique}{Word pairs: unique pairs (\code{TRUE})
or full pairs with duplicates (\code{FALSE}; default).}

\item{distance}{Compute cosine distance instead?
Defaults to \code{FALSE} (cosine similarity).}

\item{words1, words2}{[Used in \code{tab_similarity_cross}]
Two sets of words for computing similarities of n1 * n2 word pairs.}
}
\value{
A \code{data.table} of words, word pairs,
and their cosine similarity (\code{cos_sim})
or cosine distance (\code{cos_dist}).
}
\description{
Tabulate cosine similarity/distance of word pairs.
}
\section{Functions}{
\itemize{
\item \code{tab_similarity()}: Tabulate data for all word pairs.

\item \code{tab_similarity_cross()}: Tabulate data for only n1 * n2 word pairs.

}}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
tab_similarity(demodata, cc("king, queen, man, woman"))
tab_similarity(demodata, cc("king, queen, man, woman"),
               unique=TRUE)

tab_similarity(demodata, cc("Beijing, China, Tokyo, Japan"))
tab_similarity(demodata, cc("Beijing, China, Tokyo, Japan"),
               unique=TRUE)

## only n1 * n2 word pairs crossing two sets of words w1 & w2
w1 = cc("king, queen")
w2 = cc("man, woman")
tab_similarity_cross(demodata, w1, w2)

}
\seealso{
\code{\link{cosine_similarity}}

\code{\link{pair_similarity}}

\code{\link{plot_similarity}}

\code{\link{most_similar}}

\code{\link{test_WEAT}}

\code{\link{test_RND}}
}
