% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubchem_summary.R
\name{pubchem_summary}
\alias{pubchem_summary}
\title{Summarize Data from PubChem Based on Identifier}
\usage{
pubchem_summary(
  identifier,
  namespace = "cid",
  type = c("compound", "substance", "assay"),
  properties = NULL,
  include_synonyms = FALSE,
  include_sdf = FALSE,
  sdf_path = NULL,
  sdf_file_name = NULL,
  ...
)
}
\arguments{
\item{identifier}{A character string or numeric value representing the identifier for which the summary is required. It can be a compound ID (CID), substance ID (SID), assay ID (AID), or a name.}

\item{namespace}{A character string specifying the namespace of the identifier. Possible values include 'cid' for compound ID, 'sid' for substance ID, 'aid' for assay ID, and 'name' for common names or synonyms.}

\item{type}{A character vector indicating the type of data to retrieve. Possible values are "compound", "substance", and "assay". This parameter determines the kind of information fetched from PubChem.}

\item{properties}{An optional vector of property names to retrieve for the given identifier. If specified, the function fetches these properties from PubChem.}

\item{include_synonyms}{Logical; if TRUE, the function also retrieves synonyms for the given identifier.}

\item{include_sdf}{Logical; if TRUE, the function downloads the Structure-Data File (SDF) for the given identifier.}

\item{sdf_path}{An optional file path for saving the downloaded SDF file. If NULL and `include_sdf` is TRUE, the file is saved into a temporary folder with the identifier as its name.}

\item{sdf_file_name}{a character indicating the name of SDF file withoud ".sdf" extension. If NULL, default name is retrieved from \code{identifier} argument.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A list containing the requested data. The structure of the list depends on the parameters provided. It may include compound data, substance data, assay data, CIDs, SIDs, AIDs, synonyms, properties, and an SDF file path.
}
\description{
This function provides a comprehensive summary of data from the PubChem database for a given identifier. It can retrieve information about compounds, substances, assays, and additional properties, including synonyms and SDF files.
}
\examples{
\donttest{
  summary_data <- pubchem_summary(
    identifier = "aspirin",
    namespace = 'name',
    type = c("compound", "substance", "assay"),
    properties = "IsomericSMILES",
    include_synonyms = TRUE,
    include_sdf = TRUE
  )
}

}
