% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pubchem.R
\name{get_pubchem}
\alias{get_pubchem}
\title{Get Data from PubChem API}
\usage{
get_pubchem(
  identifier,
  namespace = "cid",
  domain = "compound",
  operation = NULL,
  output = "JSON",
  searchtype = NULL,
  options = NULL
)
}
\arguments{
\item{identifier}{A vector of positive integers (e.g. cid, sid, aid) or identifier strings (source, inchikey, formula). In some cases, only a single identifier string (name, smiles, xref; inchi, sdf by POST only).}

\item{namespace}{Specifies the namespace for the query. For the 'compound' domain, possible values include 'cid', 'name', 'smiles', 'inchi', 'sdf', 'inchikey', 'formula', 'substructure', 'superstructure', 'similarity', 'identity', 'xref', 'listkey', 'fastidentity', 'fastsimilarity_2d', 'fastsimilarity_3d', 'fastsubstructure', 'fastsuperstructure', and 'fastformula'. For other domains, the possible namespaces are domain-specific.}

\item{domain}{Specifies the domain of the query. Possible values are 'substance', 'compound', 'assay', 'gene', 'protein', 'pathway', 'taxonomy', 'cell', 'sources', 'sourcetable', 'conformers', 'annotations', 'classification', and 'standardize'.}

\item{operation}{Specifies the operation to be performed on the input records. For the 'compound' domain, possible operations include 'record', 'property', 'synonyms', 'sids', 'cids', 'aids', 'assaysummary', 'classification', 'xrefs', and 'description'. The available operations are domain-specific.}

\item{output}{Specifies the desired output format. Possible values are 'XML', 'ASNT', 'ASNB', 'JSON', 'JSONP', 'SDF', 'CSV', 'PNG', and 'TXT'.}

\item{searchtype}{Specifies the type of search to be performed. For structure searches, possible values are combinations of 'substructure', 'superstructure', 'similarity', 'identity' with 'smiles', 'inchi', 'sdf', 'cid'. For fast searches, possible values are combinations of 'fastidentity', 'fastsimilarity_2d', 'fastsimilarity_3d', 'fastsubstructure', 'fastsuperstructure' with 'smiles', 'smarts', 'inchi', 'sdf', 'cid', or 'fastformula'.}

\item{options}{Additional arguments passed to \code{\link{request}}.}
}
\value{
Returns the response content from the PubChem API based on the constructed URL.
}
\description{
This function constructs a URL to query the PubChem API based on the provided parameters and returns the response content.
}
\examples{
get_pubchem(
  identifier = "aspirin",
  namespace = "name"
)
}
