% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AEPD.R
\name{mleAEPD}
\alias{mleAEPD}
\title{Maximum likelihood estimation (MLE) for the quantile-based asymmetric exponential power distribution.}
\usage{
mleAEPD(y)
}
\arguments{
\item{y}{This is a vector of quantiles.}
}
\value{
The maximum likelihood estimate of parameter \eqn{\theta=(\mu,\phi,\alpha,p)} of the quantile-based asymmetric exponential power distribution.
}
\description{
The log-likelihood function \eqn{\ell_n(\mu,\phi,\alpha,p)=\ln[L_n(\mu,\phi,\alpha,p)]}
and parameter estimation of \eqn{ \theta=(\mu,\phi,\alpha,p)} in the three parameter quantile-based asymmetric exponential power distribution
by using the maximum likelihood estimation are discussed in Gijbels et al. (2019b).
}
\examples{
# Example
rnum=rnorm(100)
mleAEPD(rnum)
}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019b). Quantile estimation in a generalized  asymmetric distributional setting. To appear in \emph{Springer Proceedings in Mathematics & Statistics, Proceedings of `SMSA 2019', the 14th Workshop on Stochastic Models, Statistics and their Application}, Dresden, Germany, in March 6--8, 2019. Editors: Ansgar Steland, Ewaryst Rafajlowicz, Ostap Okhrin.
}
}
