% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{gigwa_get_metadata}
\alias{gigwa_get_metadata}
\title{Get the metadate of the current active GIGWA run}
\usage{
gigwa_get_metadata()
}
\value{
a data.frame of all metadata associated to the samples in the selected run
}
\description{
This function will retrieve the metadata of the current active run
as configured in the internal state object using `gigwa_set_run()` function.
}
\examples{
if(interactive()) {
# config your GIGWA connection
set_qbms_config("https://gigwa.southgreen.fr/gigwa/", 
                time_out = 300, engine = "gigwa", no_auth = TRUE)

# select a database by name
gigwa_set_db("3kG_10M")

# select a project by name
gigwa_set_project("3003_ind")

# select a specific run by name
gigwa_set_run("1")

# get a list of all samples in the selected run
metadata <- gigwa_get_metadata()
}
}
\seealso{
\code{\link{set_qbms_config}}, \code{\link{gigwa_set_run}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
