% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_germplasm_data}
\alias{get_germplasm_data}
\title{Retrieve Observations Data for a Specified Germplasm.}
\usage{
get_germplasm_data(germplasm_name = "")
}
\arguments{
\item{germplasm_name}{The name of the germplasm.}
}
\value{
A data frame containing the aggregated observations data for the germplasm from all trials.
}
\description{
Retrieves all available observations data for a given germplasm in the current 
crop database, regardless of the nested structure of programs/trials.
}
\examples{
if (interactive()) {
  # Configure server connection
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  
  # Log in using your account (interactive mode)
  # You can pass your username and password as parameters (batch mode)
  login_bms()
  
  # Select a crop
  set_crop("wheat")
  
  # Select a breeding program by name
  set_program("Wheat International Nurseries")
  
  # Retrieve observations data for a specified germplasm aggregated from all trials
  germplasm_observations <- get_germplasm_data("Jabal")
}
}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{get_germplasm_attributes}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
