% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{set_trial}
\alias{set_trial}
\title{Set the Current Active Trial}
\usage{
set_trial(trial_name)
}
\arguments{
\item{trial_name}{The name of the trial.}
}
\value{
No return value.
}
\description{
Updates the current active trial in the internal state object using the 
trialDbId which is associated with the given trial_name parameter.
}
\examples{
if(interactive()) {
  # Configure your server connection
  set_qbms_config("https://bms.icarda.org/ibpworkbench")

  # Login using your account (interactive mode)
  # You can pass your username and password as parameters (batch mode)
  login_bms()

  # Select a crop by name
  set_crop("wheat")

  # Select a breeding program by name
  set_program("Wheat International Nurseries")

  # Select a specific study/trial by name
  set_trial("IDYT39")
}

}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{list_trials}}
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
