% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{login_oauth2}
\alias{login_oauth2}
\title{Login using OAuth 2.0 Authentication}
\usage{
login_oauth2(
  authorize_url,
  access_url,
  client_id,
  client_secret = NULL,
  redirect_uri = "http://localhost:1410"
)
}
\arguments{
\item{authorize_url}{The URL where the client is redirected for user authorization.}

\item{access_url}{The URL used to exchange an authorization code for an access token.}

\item{client_id}{The client ID (consumer key) provided by the authorization server.}

\item{client_secret}{The client secret provided by the authorization server (optional).}

\item{redirect_uri}{The URL where the user will be redirected after authorization (default is http://localhost:1410).}
}
\value{
No return value. Updates the internal state with the access token and additional details.
}
\description{
Performs OAuth 2.0 authentication by sending the user to the authorization URL and exchanging the 
authorization code for an access token. This function supports caching of tokens for subsequent requests.
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}
}
