.onAttach <- function (...) {
 
 meta <- packageDescription("QCApro")
 year <- sub("-.*", "", meta$Date)
 title <- meta$Title
 note <- sprintf("R Package Version %s.", meta$Version)
 
 msg1 <- paste("Thiem, Alrik.", sprintf("%s.", year),
              sprintf("%s.", title), note,
              "URL: http://www.alrik-thiem.net/software/.")
 
 msg1 <- paste(strwrap(msg1, indent = 2, exdent = 2), collapse = "\n")
 
 packageStartupMessage("\nPlease cite the 'QCApro' package as follows:\n\n",
                       msg1, "\n\nA BibTeX entry can be generated by:\n\n  citation(package = \"QCApro\")\n",
                       "\nAll improvements and bug fixes on the predecessor package QCA 1.1-4\nas well as all internal package changes can be browsed by:\n\n  news(package = \"QCApro\")\n",
                       "\nNOTE: As some function and object names currently overlap with the QCAGUI\npackage, you should work with only either QCApro or QCAGUI within one R session.\n")
}
