\name{factorize}

\alias{factorize}

\title{Factorize Configurational Expressions}

\description{
This function finds all possibilities for factorizing a configurational expression.
}

\usage{
factorize(expression, and.split = "", sort.factorizing = FALSE, 
          sort.factorized = FALSE)
}

\arguments{
  \item{expression}{A string representing a configurational expression or a QCA
        solution object of class \dQuote{qca} generated by \code{eQMC()}.}
  \item{and.split}{The AND-operator (if any).}
  \item{sort.factorizing}{Logical, sort results beginning with largest number of 
        factorizing elements.}
  \item{sort.factorized}{Logical, sort results beginning with largest number of 
        factorized elements.}
}

\details{
In Boolean algebra, the \dQuote{*}-operator is distributive over the \dQuote{+}- 
operator such that for any three literals \eqn{a}, \eqn{b} and \eqn{c}, the 
following law holds: \eqn{(a*b) + (a*c) = a*(b + c)}{(a*b) + (a*c) = a*(b + c)} 
(Hohn 1966, pp.78-80; South 1974, p.12). The '\code{factorize}' function finds 
all possible \eqn{a}{a} for any configurational expression. Factorized versions 
of the initial expression(s) can be sorted in decreasing order by the number of 
factorizing literals or in decreasing order by the number of factorized literals. 
}

\value{A list with the following components:\cr
  \item{initial}{The initial expression.}
  \item{factored}{The factorizations of the initial expression.}
}

\author{
Alrik Thiem (\href{http://www.alrik-thiem.net}{Personal Website}; \href{https://www.researchgate.net/profile/Alrik_Thiem}{ResearchGate Website})
}

\section{Contributors}{\tabular{ll}{
Dusa, Adrian\tab: development, programming, testing\cr
Thiem, Alrik\tab: development, documentation, testing
}}

\references{
Hohn, Franz E. 1966. \emph{Applied Boolean Algebra: An Elementary Introduction}. 
2nd ed. New York: Macmillan.

South, G. F. 1974. \emph{Boolean Algebra and Its Uses}. New York: Van Nostrand Reinhold.
}

\seealso{\code{\link{eQMC}}}

\examples{
# factorize a disjunction of two two-way conjunctions;
# if single letters are used, argument "and.split" is not needed
factorize("AB + AC")

# "and.split" is needed in these cases
factorize("one*TWO*four + one*THREE + THREE*four", and.split = "*")
factorize("~ONE*TWO*~FOUR + ~ONE*THREE + THREE*~FOUR", and.split = "*")
factorize("one&TWO&four + one&THREE + THREE&four", and.split = "&")

# factorize solution objects directly
data(d.represent)
KRO.sol <- eQMC(d.represent, outcome = "WNP")
factorize(KRO.sol)
}

\keyword{functions}
