% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdq.test.R
\name{rdq.test}
\alias{rdq.test}
\title{tests for QTE}
\usage{
rdq.test(y,x,d,x0,z0=NULL,tau,bdw,cov,bias,alpha,type,std.opt=1,print.qte=1)
}
\arguments{
\item{y}{a numeric vector, the outcome variable.}

\item{x}{a vector (or a matrix) of covariates, the first column is the running variable.}

\item{d}{a numeric vector, the treatment status.}

\item{x0}{the cutoff point.}

\item{z0}{the value of the covariates at which to evaluate the effects.
For example, if a female dummy is included, z0 = 1 indicates the female subgroup.}

\item{tau}{a vector of quantiles of interest.}

\item{bdw}{the bandwidth value(s). If 'bdw' is a scalar, it is interpreted as the
bandwidth for the median. The bandwidths for the rest of the quantiles are
computed automatically using the formula in Yu and Jones (1998).
If it is a vector with the same dimension as 'tau',
the function will use these values for the respective quantiles accordingly.}

\item{cov}{either 0 or 1. Set cov=1 when covariates are present in the model;
otherwise set cov=0.}

\item{bias}{either 0 or 1. If bias=1, the QTE estimate is bias corrected and
the robust confidence band in Qu, Yoon, and Perron (2024) is produced.
If bias=0, no bias correction is implemented.}

\item{alpha}{a number between 0 and 1, the desired significance level.
When alpha=0.1, one will get a 90\% uniform band.}

\item{type}{a value in 1--4. Set \emph{type} to 1 to test the null hypothesis of a zero
treatment effect against the alternative hypothesis of significant treatment effects;
set \emph{type} to 2 to test the null hypothesis of homogeneous treatment against heterogeneous treatment effects;
set \emph{type} to 3 to test the null hypothesis of uniformly non-negative treatment effects against the presence of negative effects;
and set \emph{type} to 4 to test the null hypothesis of uniformly non-positive treatment effects against the presence of positive effects at some quantiles.}

\item{std.opt}{either 0 or 1. If \emph{std.opt=1}, the test statistic is standardized so that
the variance is equalized across quantiles; if \emph{std.opt=0}, the test is not standardized.}

\item{print.qte}{a logical flag specifying whether to print an outcome table.}
}
\value{
A list with elements:
\describe{
\item{te.st}{test statistics}
\item{cr.va}{critical values.}
}
}
\description{
\code{rdq.test} provides testing results for hypotheses on the treatment effects concerning (i) treatment significance, (ii) homogeneity of effects over quantiles,
and (iii) positive or negative dominance hypothesis.
}
\examples{
# Without covariate
n = 500
x = runif(n,min=-4,max=4)
d = (x > 0)
y = x + 0.3*(x^2) - 0.1*(x^3) + 1.5*d + rnorm(n)
tlevel = seq(0.1,0.9,by=0.1)
B = rdq.test(y=y,x=x,d=d,x0=0,z0=NULL,tau=tlevel,bdw=2,cov=0,bias=1,alpha=c(0.1,0.05),type=c(1,2,3))

# (continued) With covariates
z = sample(c(0,1),n,replace=TRUE)
y = x + 0.3*(x^2) - 0.1*(x^3) + 1.5*d + d*z + rnorm(n)
\donttest{B = rdq.test(y=y,x=cbind(x,z),d=d,x0=0,z0=c(0,1),tau=tlevel,bdw=2,cov=1,bias=1,
alpha=c(0.1,0.05),type=c(3,4))}


}
\references{
Zhongjun Qu, Jungmo Yoon, Pierre Perron (2024), "Inference on Conditional Quantile
Processes in Partially Linear Models with Applications to the Impact of Unemployment Benefits,"
The Review of Economics and Statistics; https://doi.org/10.1162/rest_a_01168

Zhongjun Qu and Jungmo Yoon (2019), "Uniform Inference on Quantile Effects
under Sharp Regression Discontinuity Designs," Journal of Business and Economic Statistics,
37(4), 625–647; https://doi.org/10.1080/07350015.2017.1407323
}
