% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.fmx.R
\name{as_fmx_mixsmsn}
\alias{as_fmx_mixsmsn}
\alias{as.fmx.Skew.normal}
\alias{as.fmx.Normal}
\alias{as.fmx.Skew.t}
\alias{as.fmx.t}
\title{Convert Objects from \pkg{mixsmsn} to \linkS4class{fmx} Objects}
\usage{
\method{as.fmx}{Skew.normal}(x, data, engine = c("sn", "mixsmsn"), ...)

\method{as.fmx}{Normal}(x, data, ...)

\method{as.fmx}{Skew.t}(x, data, engine = c("sn", "mixsmsn"), ...)

\method{as.fmx}{t}(x, data, ...)
}
\arguments{
\item{x}{\code{Normal}, \code{Skew.normal}, \code{t}, \code{Skew.t} object, returned from \link[mixsmsn]{smsn.mix} with option \code{family = 'Skew.normal'}}

\item{data}{\link[base]{numeric} \link[base]{vector}}

\item{engine}{\link[base]{character} scalar for \code{Skew.normal} and \code{Skew.t} method dispatch,
either \CRANpkg{sn}
(default, using \link[sn]{dsn}, \link[sn]{psn}, \link[sn]{dst} or \link[sn]{pst}),
or \CRANpkg{mixsmsn} (using my re-written \link{dSN} and \link{dST}, but I do not have function \code{pSN} or \code{pST}).}

\item{...}{..}
}
\value{
\link{as.fmx.Skew.normal}, \code{as.fmx.Normal} and \link{as.fmx.Skew.t} return an \linkS4class{fmx} object.

\link{as.fmx.t} has not been completed yet
}
\description{
..
}
\note{
\link[mixsmsn]{smsn.mix} does not offer a parameter to keep the input data, as of 2021-10-06.
}
\examples{

if (FALSE) {
# all examples work
# disabled as they are slow

library(mixsmsn)
# ?smsn.mix
arg1 = c(mu = 5, sigma2 = 9, lambda = 5, nu = 5)
arg2 = c(mu = 20, sigma2 = 16, lambda = -3, nu = 5)
arg3 = c(mu = 35, sigma2 = 9, lambda = -6, nu = 5)
set.seed(120); x = rmix(n = 1e3L, p=c(.5, .2, .3), family = 'Skew.t', 
  arg = list(unname(arg1), unname(arg2), unname(arg3)))
  
# Skew Normal
class(m <- smsn.mix(x, nu = 3, g = 3, family = 'Skew.normal', calc.im = FALSE))
mix.hist(y = x, model = m)

m2 = as.fmx(m, data = x, engine = 'mixsmsn')
autoplot(m2)
(l2 = logLik(m2))
stopifnot(identical(AIC(m2), m$aic), identical(BIC(m2), m$bic))
tryCatch(fmx_diagnosis(m2, type = 'Kolmogorov'), error = identity)
tryCatch(fmx_diagnosis(m2, type = 'CramerVonMises'), error = identity)

m3 = as.fmx(m, data = x, engine = 'sn')
autoplot(m3)
(l3 = logLik(m3))
stopifnot(identical(AIC(m3), m$aic), identical(BIC(m3), m$bic))
autoplot(m3, type = 'distribution')
fmx_diagnosis(m3, type = 'Kolmogorov')
fmx_diagnosis(m3, type = 'CramerVonMises')

fmx_diagnosis(m2, type = 'KullbackLeibler') - fmx_diagnosis(m3, type = 'KullbackLeibler')

identical(l2, l3)
range(attr(l2, 'logl') - attr(l3, 'logl'))

if (FALSE) {
(x0 = x[729]) # only wrong
#range(qfmx(pfmx(x[-729], dist = m3), dist = m3) - x[-729])
#range(qfmx(pfmx(x[-729], dist = m3, lower.tail = F), dist = m3, lower.tail = F) - x[-729])
qfmx(pfmx(x0, dist = m3), dist = m3)
qfmx(pfmx(x0, dist = m3, lower.tail = FALSE), dist = m3, lower.tail = FALSE)
qfmx_interval(m3) # using interval end.   I have no plan to fix this error.
}

# Normal
class(m <- smsn.mix(x, nu = 3, g = 3, family = 'Normal', calc.im = FALSE))
mix.hist(y = x, model = m)
autoplot(as.fmx(m, data = x))


# skew t
set.seed(131534); x = rmix(n = 1e3L, p = c(.5, .2, .3), family = 'Skew.t', 
  arg = list(unname(arg1), unname(arg2), unname(arg3)))

g = 3
class(m <- smsn.mix(x, nu = 3, g = g, family = 'Skew.t', calc.im = FALSE))
mix.hist(y = x, model = m)

m2 = as.fmx(m, data = x, engine = 'mixsmsn')
autoplot(m2)
(l2 = logLik(m2))
attr(l2, 'df') = g*3 + 1 + (g-1) # ?mixsmsn::smsn.mix gives same `nu` for all components
stopifnot(all.equal.numeric(AIC(l2), m$aic), all.equal.numeric(BIC(l2), m$bic))
tryCatch(fmx_diagnosis(m2, type = 'Kolmogorov'), error = identity)
tryCatch(fmx_diagnosis(m2, type = 'CramerVonMises'), error = identity)

m3 = as.fmx(m, data = x, engine = 'sn')
autoplot(m3)
(l3 = logLik(m3))
attr(l3, 'df') = g*3 + 1 + (g-1) # same reason
stopifnot(all.equal.numeric(AIC(l3), m$aic), all.equal.numeric(BIC(l3), m$bic))
autoplot(m3, type = 'distribution')
fmx_diagnosis(m3, type = 'Kolmogorov')
fmx_diagnosis(m3, type = 'CramerVonMises')

fmx_diagnosis(m2, type = 'KullbackLeibler') - fmx_diagnosis(m3, type = 'KullbackLeibler')

identical(l2, l3)
range(attr(l2, 'logl') - attr(l3, 'logl'))

# t
class(m <- smsn.mix(x, nu = 3, g = 3, family = 't', calc.im = FALSE))
mix.hist(y = x, model = m)
# autoplot(as.fmx(m, data = x)) # not ready yet!!
}



}
\seealso{
\link[mixsmsn]{smsn.mix}
}
