% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QLMDp.R
\name{QLMDp}
\alias{QLMDp}
\title{Percentages for Quantile Least Mahalanobis Distance estimation}
\usage{
QLMDp(
  from = 0.05,
  to = 0.95,
  length.out = 15L,
  equidistant = c("prob", "quantile"),
  extra = c(0.005, 0.01, 0.02, 0.03, 0.97, 0.98, 0.99, 0.995),
  x
)
}
\arguments{
\item{from, to}{\link[base]{numeric} scalar,
minimum and maximum of the equidistant (in probability or quantile) probabilities.
Default \code{.05} and \code{.95}, respectively}

\item{length.out}{non-negative \link[base]{integer} scalar,
the number of the equidistant (in probability or quantile) probabilities.}

\item{equidistant}{\link[base]{character} scalar.
If \code{'prob'} (default), then the probabilities are equidistant.
If \code{'quantile'}, then the quantiles (of the observations \code{x}) corresponding to the probabilities are equidistant.}

\item{extra}{\link[base]{numeric} \link[base]{vector} of \emph{additional} probabilities,
default \code{c(.005, .01, .02, .03, .97, .98, .99, .995)}.}

\item{x}{\link[base]{numeric} \link[base]{vector} of observations, only used when \code{equidistant = 'quantile'}.}
}
\value{
A \link[base]{numeric} \link[base]{vector} of probabilities to be supplied to parameter \code{p} of
Quantile Least Mahalanobis Distance \link{QLMDe} estimation).
In practice, the length of this probability \link[base]{vector} \code{p}
must be equal or larger than the number of parameters in the distribution model to be estimated.
}
\description{
A vector of probabilities to be used in Quantile Least Mahalanobis Distance estimation (\link{QLMDe}).
}
\details{
The default arguments of function \link{QLMDp} returns the probabilities of
\code{c(.005, .01, .02, .03, seq.int(.05, .95, length.out = 15L), .97, .98, .99, .995)}.
}
\examples{
library(fmx)
(d2 = fmx('GH', A = c(1,6), B = 2, g = c(0,.3), h = c(.2,0), w = c(1,2)))
set.seed(100); hist(x2 <- rfmx(n = 1e3L, dist = d2))

# equidistant in probabilities
(p1 = QLMDp()) 

# equidistant in quantiles
(p2 = QLMDp(equidistant = 'quantile', x = x2)) 
}
