% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_summaries.R
\name{summary.gcFitLinear}
\alias{summary.gcFitLinear}
\title{Generic summary function for gcFitLinear objects}
\usage{
\method{summary}{gcFitLinear}(object, ...)
}
\arguments{
\item{object}{object of class \code{gcFitLinear}}

\item{...}{Additional arguments. This has currently no effect and is only meant to fulfill the requirements of a generic function.}
}
\value{
A dataframe with parameters extracted from the linear fit.
}
\description{
Generic summary function for gcFitLinear objects
}
\examples{
# Create random growth dataset
rnd.dataset <- rdm.data(d = 35, mu = 0.8, A = 5, label = 'Test1')

# Extract time and growth data for single sample
time <- rnd.dataset$time[1,]
data <- rnd.dataset$data[1,-(1:3)] # Remove identifier columns

# Perform linear fit
TestFit <- growth.gcFitLinear(time, data, gcID = 'TestFit',
                 control = growth.control(fit.opt = 'l'))

summary(TestFit)

}
