% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QvalIndex.R
\name{zUSR}
\alias{zUSR}
\title{Calculate Under-Specification Rate (USR)}
\usage{
zUSR(Q.true, Q.sug)
}
\arguments{
\item{Q.true}{The true Q-matrix.}

\item{Q.sug}{The Q-matrix that has been validated.}
}
\value{
A numeric (USR index).
}
\description{
Calculate Under-Specification Rate (USR)
}
\details{
The USR is defned as:
\deqn{
 USR = \frac{\sum_{i=1}^{I}\sum_{k=1}^{K}I(q_{ik}^{t} > q_{ik}^{s})}{I × K}
}
where \eqn{q_{ik}^{t}} denotes the \eqn{k}th attribute of item \eqn{i} in the true Q-matrix (\code{Q.true}),
\eqn{q_{ik}^{s}} denotes \eqn{k}th attribute of item \eqn{i} in the suggested Q-matrix(\code{Q.sug}),
and \eqn{I(\cdot)} is the indicator function.
}
\examples{
library(Qval)

set.seed(123)

Q1 <- sim.Q(5, 30)
Q2 <- sim.MQ(Q1, 0.1)
USR <- zUSR(Q1, Q2)
print(USR)

}
