#########################################################################/**
# @RdocDefault generateCache
#
# @title "Generates a cache pathname from a key object"
#
# \description{
#  @get "title".
# }
#
# @synopsis
#
# \arguments{
#   \item{key}{A @list or an @environment from which a hexadecimal 
#     key will be generated and that will constitute the name part of
#     the cache filename.}
#   \item{suffix}{A @character string to be appended to the end of the
#     filename.}
#   \item{...}{Arguments passed to @see "getCachePath".}
# }
#
# \value{
#   Returns the path as a @character string.
# }
#
# @author
#
# @keyword "programming"
# @keyword "IO"
# @keyword "internal"
#*/######################################################################### 
setMethodS3("generateCache", "default", function(key=NULL, suffix=".Rcache", ...) {
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Validate arguments
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Argument 'key':
  if (!is.null(key)) {
    if (!is.list(key) && !is.environment(key)) {
      throw("Argument 'key' must be a list, an environment or NULL: ", 
                                                            class(key)[1]);
    }

    # Using key object requires the CRAN package 'digest'.
    require(digest) || throw("Package not loaded: digest");
  }

  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  # Generate cache name from hash code of key object
  # - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  if (!is.null(key)) {
    hashCode <- digest::digest(key);
    cacheName <- hashCode;
  }

  # Add cache directory or pathname
  path <- getCachePath(...);
  cacheName <- file.path(path, cacheName);

  # Add suffix
  cacheName <- paste(cacheName, suffix, sep="");


  cacheName;
})


############################################################################
# HISTORY:
# 2007-07-02
# o Added support for argument 'key' is an environment.
# 2005-12-09
# o Removed 'file' argument.
# 2005-12-06
# o Created.
############################################################################
