%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Do not modify this file since it was automatically generated from:
% 
%  
% 
% on Mon Jul 18 15:08:19 2005.
% 
% Generator was the Rdoc class, which is part of the R.oo package written
% by Henrik Bengtsson, 2001-2004.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{Rdoc}
\docType{class}
\alias{Rdoc}


\title{Class for converting Rdoc comments to Rd files}

\description{
 Package:  R.oo \cr
\bold{Class Rdoc}\cr

\code{\link[R.oo]{Object}}\cr
\code{~~|}\cr
\code{~~+--}\code{Rdoc}\cr

\bold{Directly known subclasses:}\cr
\cr

public static class \bold{Rdoc}\cr
extends \link[R.oo]{Object}\cr



 Class for converting Rdoc comments to Rd files.
}

\usage{Rdoc()}

\section{Fields and Methods}{
 \bold{Methods:}\cr
\tabular{rll}{
 \tab \code{\link[R.oo:check.Rdoc]{check}} \tab Checks the compiled Rd files.\cr
 \tab \code{\link[R.oo:compile.Rdoc]{compile}} \tab Compile source code files containing Rdoc comments into Rd files.\cr
 \tab \code{\link[R.oo:createManPath.Rdoc]{createManPath}} \tab Creates the directory where the Rd files should be saved.\cr
 \tab \code{\link[R.oo:escapeRdFilename.Rdoc]{escapeRdFilename}} \tab Escape non-valid characters in a filename.\cr
 \tab \code{\link[R.oo:getKeywords.Rdoc]{getKeywords}} \tab Gets the keywords defined in R with descriptions.\cr
 \tab \code{\link[R.oo:getManPath.Rdoc]{getManPath}} \tab Gets the path to the directory where the Rd files will be saved.\cr
 \tab \code{\link[R.oo:getNameFormat.Rdoc]{getNameFormat}} \tab Gets the current name format.\cr
 \tab \code{\link[R.oo:isKeyword.Rdoc]{isKeyword}} \tab Checks if a word is a Rd keyword.\cr
 \tab \code{\link[R.oo:setManPath.Rdoc]{setManPath}} \tab Sets the path to the directory where the Rd files should be saved.\cr
 \tab \code{\link[R.oo:setNameFormat.Rdoc]{setNameFormat}} \tab Sets the current name format.\cr
}


\bold{Methods inherited from Object}:\cr
$, $<-, [[, [[<-, as.character, attach, attachLocally, clone, detach, equals, extend, finalize, getFields, getInstanciationTime, getStaticInstance, hasField, hashCode, ll, load, objectSize, print, save


}

\author{Henrik Bengtsson \url{http://www.braju.com/R/}}

\examples{\dontrun{# Set default author
author <- "Henrik Bengtsson, \\url{http://www.braju.com/R/}"

# Show the file containing the Rdoc comments
rdocFile <- system.file("misc", "ASCII.R", package="R.oo")
file.show(rdocFile)

# Compile the Rdoc:s into Rd files (saved in the destPath directory)
destPath <- tempdir()
Rdoc$compile(rdocFile, destPath=destPath)

# List the generated Rd files
rdFiles <- list.files(destPath, full.names=TRUE)
print(rdFiles)

# Show one of the files
file.show(rdFiles[1])

# Clean up
file.remove(rdFiles)
}}

\references{
  R developers,
  \emph{Guidelines for Rd files},
  \url{http://developer.r-project.org/Rds.html},
  2003

  Gordon Smyth,
  \emph{Writing .Rd Files For S4 Classes, Generic Functions and Methods},
  \url{http://bioinf.wehi.edu.au/limma/Rdocs.html},
  2003
}


\keyword{classes}
\keyword{documentation}
