% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.R
\name{combine_terms}
\alias{combine_terms}
\title{combine_terms}
\usage{
combine_terms(dtm, dict)
}
\arguments{
\item{dtm}{A \code{DocumentTermMatrix} object.}

\item{dict}{A \code{data.frame} with one row per term in \code{dtm} that should be retained.
The row names must match names of rows in \code{dtm}, and the first column must give the
term into which it should be transformed.}
}
\value{
An aggregated \code{DocumentTermMatrix} object.
}
\description{
Aggregate terms in a document-term matrix to according to groupings specified
by a dictionary.
}
\details{
If several terms use the same transformation, they will be aggregated together.
Terms missing from \code{dict} will be dropped.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
dict <- dictionary(dtm)
combine_terms(dtm, dict)

}
