% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms.R
\name{specific_terms}
\alias{specific_terms}
\title{specific_terms}
\usage{
specific_terms(
  dtm,
  variable = NULL,
  p = 0.1,
  n = 25,
  sparsity = 1,
  min_occ = 2
)
}
\arguments{
\item{dtm}{A \code{DocumentTermMatrix}.}

\item{variable}{An optional vector of values giving the groups for which most frequent
terms should be reported.}

\item{p}{The maximum p-value up to which terms should be reported.}

\item{n}{The maximal number of terms to report (for each group, if applicable).}

\item{sparsity}{Value between 0 and 1 indicating the proportion of documents
with no occurrences of a term above which that term should be dropped. By default
all terms are kept (\code{sparsity=1}).}

\item{min_occ}{The minimum number of occurrences in the whole \code{dtm} below which
terms should be skipped.}
}
\value{
A list of matrices, one for each level of the variable, with columns:
\itemize{
\item "\\% Term/Level": the percent of the term's occurrences in all terms occurrences in the level.
\item "\\% Level/Term": the percent of the term's occurrences that appear in the level
(rather than in other levels).
\item "Global \\%": the percent of the term's occurrences in all terms occurrences in the corpus.
\item "Level": the number of occurrences of the term in the level ("internal").
\item "Global": the number of occurrences of the term in the corpus.
\item "t value": the quantile of a normal distribution corresponding the probability "Prob.".
\item "Prob.": the probability of observing such an extreme (high or low) number of occurrences of
the term in the level, under an hypergeometric distribution.
}
}
\description{
List terms most associated (positively or negatively) with each document or each
of a variable's levels.
}
\details{
Specific terms reported here are those whose observed frequency in the document or level has
the lowest probability under an hypergeometric distribution, based on their global frequencies
in the corpus and on the number of occurrences of all terms in the document or variable level considered.
The positive or negative character of the association is visible from the sign of the t value,
or by comparing the value of the "\\% Term/Level" column with that of the "Global \\%"
column.
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
specific_terms(dtm)
specific_terms(dtm, meta(corpus)$Date)

}
