\name{svg2swf}
\alias{svg2swf}
\title{Convert a sequence of SVG files to SWF file}
\usage{
svg2swf(input, output = "./movie.swf", bgColor = "white", interval = 1)
}
\arguments{
  \item{input}{the file names of the SVG files to be
  converted}

  \item{output}{the name of the output SWF file}

  \item{bgColor}{background color of the output SWF file}

  \item{interval}{the time interval (in seconds) between
  animation frames}
}
\value{
  The path of the generated SWF file if successful.
}
\description{
  Given the file names of a sequence of SVG files, this
  function could convert them into a Flash file (.swf).
}
\details{
  This function uses the XML package in R and a subset of
  librsvg (\url{http://librsvg.sourceforge.net/}) to parse
  the SVG file, and uses the Ming library
  (\url{http://www.libming.org/}) to implement the
  conversion. Currently this function supports SVG files
  created by \code{\link[grDevices]{svg}()} in the
  \pkg{grDevices} package, and
  \code{\link[Cairo]{CairoSVG}()} in the \pkg{Cairo}
  package.
}
\examples{
\dontrun{
if (capabilities("cairo")) {
    olddir = setwd(tempdir())
    svg("Rplot\%03d.svg", onefile = FALSE)
    set.seed(123)
    x = rnorm(5)
    y = rnorm(5)
    for (i in 1:100) {
        plot(x <- x + 0.1 * rnorm(5), y <- y + 0.1 * rnorm(5), xlim = c(-3, 
            3), ylim = c(-3, 3), col = "steelblue", pch = 16, cex = 2, xlab = "x", 
            ylab = "y")
    }
    dev.off()
    output = svg2swf(sprintf("Rplot\%03d.svg", 1:100), interval = 0.1)
    swf2html(output)
    setwd(olddir)
}
}
}
\author{
  Yixuan Qiu <\email{yixuan.qiu@cos.name}>
}
