% Generated by roxygen2 (4.0.1): do not edit by hand
\name{cdbRemoveDB}
\alias{cdbRemoveDB}
\title{Function to remove a database}
\usage{
cdbRemoveDB(cdb)
}
\arguments{
\item{cdb}{The \code{cdb} has to provide \code{cdb$serverName},
\code{cdb$port} and \code{cdb$DBName}}
}
\value{
\item{cdb}{The CouchDB answer is stored in \code{cdb$res}. Any
problems on the R side are reportet in \code{cdb$error} }
}
\description{
Removing a database means sending a http- "DELETE"- request to
\code{http://cdb$serverName:cdb$port/ ...}
}
\details{
In \code{cdb} a entry \code{cdb$delDBName} should be provided for more
explicit deleting respectively more secure removing.
}
\examples{
\dontrun{
ccc               <- cdbIni()
ccc$newDBName     <- "r4couchdb_db"
ccc               <- cdbMakeDB(ccc)
ccc$res
ccc$removeDBName  <- ccc$DBName
cdbRemoveDB(ccc)$res
}
}
\author{
wactbprot
}
\references{
\url{ http://couchdb.apache.org/ }
}
\seealso{
\code{cdbMakeDB}
}
\keyword{misc}

