% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_rafs_occurrence_matrix}
\alias{get_rafs_occurrence_matrix}
\title{Get co-occurrence matrix from RAFS results}
\usage{
get_rafs_occurrence_matrix(
  rafs_results,
  interesting_reps,
  n_clusters_range = 2:15
)
}
\arguments{
\item{rafs_results}{RAFS results as obtained from \code{\link{run_rafs}}}

\item{interesting_reps}{the interesting representatives to build matrices for (in principle, these need not be representatives but it is more common)}

\item{n_clusters_range}{range of clusters number to obtain matrices for}
}
\value{
A nested \code{\link{list}} with matrices.
  The first level is per the RAFS variant (combination of feature dissimilarity function and hclust method).
  The second level is per the number of clusters.
  The third (and last) level is the co-occurrence matrix.
}
\description{
This function obtains a matrix describing a graph of co-occurrence
at each count of clusters (from \code{n_clusters_range}) computed
over all runs of RAFS.
}
\details{
If a single result over a cluster number range is desired, the selected matrices can be summed.
}
\examples{
library(MDFS)
mdfs_omp_set_num_threads(1)  # only to pass CRAN checks
data(madelon)
rafs_results <- run_rafs(madelon$data, madelon$decision, 2, c(12345))
rafs_reps_popcnts <- get_rafs_reps_popcnts(rafs_results, 5)
rafs_top_reps <- get_rafs_top_reps_from_popcnts(rafs_reps_popcnts$stig_single, 5)
get_rafs_occurrence_matrix(rafs_results, rafs_top_reps, 5)
}
