% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_rafs_reps_popcnts}
\alias{get_rafs_reps_popcnts}
\title{Get representatives' popularity counts (popcnts) from RAFS results}
\usage{
get_rafs_reps_popcnts(rafs_results, n_clusters_range = 2:15)
}
\arguments{
\item{rafs_results}{RAFS results as obtained from \code{\link{run_rafs}}}

\item{n_clusters_range}{range of clusters number to obtain popcnts for}
}
\value{
A nested \code{\link{list}} with popcnts.
  The first level is per the RAFS variant (combination of feature dissimilarity function and hclust method).
  The second level is per the number of clusters.
  The third (and last) level is popcnts per representative.
}
\description{
This function obtains popularity counts (popcnts) of representatives
present at each count of clusters (from \code{n_clusters_range}) computed
over all runs of RAFS.
}
\details{
These results might be fed into further helper functions:
\code{\link{get_rafs_top_reps_from_popcnts}} and \code{\link{get_rafs_all_reps_from_popcnts}}.
}
\examples{
library(MDFS)
mdfs_omp_set_num_threads(1)  # only to pass CRAN checks
data(madelon)
rafs_results <- run_rafs(madelon$data, madelon$decision, 2, c(12345))
get_rafs_reps_popcnts(rafs_results, 2:5)
}
