% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_useful_functions.R
\name{plotPhyloTree}
\alias{plotPhyloTree}
\title{Function to plot phylogenetic tree from the estimated results}
\usage{
plotPhyloTree(
  estPhyloRes,
  traitName = NULL,
  blockName = NULL,
  plotTree = TRUE,
  subpopInfo = estPhyloRes$subpopInfo,
  saveName = NULL,
  saveStyle = "png",
  pchBase = c(1, 16),
  colNodeBase = c(2, 4),
  colTipBase = c(3, 5, 6),
  cexMax = 2,
  cexMin = 0.7,
  edgeColoring = TRUE,
  tipLabel = TRUE,
  ggPlotTree = FALSE,
  cexMaxForGG = 0.12,
  cexMinForGG = 0.06,
  alphaBase = c(0.9, 0.3)
)
}
\arguments{
\item{estPhyloRes}{The estimated results of phylogenetic analysis by `estPhylo` function for one}

\item{traitName}{Name of trait of interest. This will be used in the title of the plots.}

\item{blockName}{You can specify the haplotype block (or gene set, SNP-set) of interest by the name of haplotype block in `geno`.
This will be used in the title of the plots.}

\item{plotTree}{If TRUE, the function will return the plot of phylogenetic tree.}

\item{subpopInfo}{The information of subpopulations.}

\item{saveName}{When drawing any plot, you can save plots in png format. In saveName, you should substitute the name you want to save.
When saveName = NULL, the plot is not saved.}

\item{saveStyle}{This argument specifies how to save the plot of phylogenetic tree.
The function offers `png`, `pdf`, `jpg`, and `tiff`.}

\item{pchBase}{A vector of two integers specifying the plot types for the positive and negative genotypic values respectively.}

\item{colNodeBase}{A vector of two integers or chracters specifying color of nodes for the positive and negative genotypic values respectively.}

\item{colTipBase}{A vector of integers or chracters specifying color of tips for the positive and negative genotypic values respectively.
The length of the vector should equal to the number of subpopulations.}

\item{cexMax}{A numeric specifying the maximum point size of the plot.}

\item{cexMin}{A numeric specifying the minimum point size of the plot.}

\item{edgeColoring}{If TRUE, the edge branch of phylogenetic tree wiil be colored.}

\item{tipLabel}{If TRUE, lavels for tips will be shown.}

\item{ggPlotTree}{If TRUE, the function will return the ggplot version of phylogenetic tree.
It offers the precise information on subgroups for each haplotype.}

\item{cexMaxForGG}{A numeric specifying the maximum point size of the plot for ggtree,
relative to the range of x and y-axes (0 < cexMaxForGG <= 1).}

\item{cexMinForGG}{A numeric specifying the minimum point size of the plot for ggtree,
relative to the range of x and y-axes (0 < cexMaxForGG <= 1).}

\item{alphaBase}{alpha (parameter that indicates the opacity of a geom) for tip with positive / negative effects.
alpha for node will be same as the alpha for tip with negative effects.}
}
\value{
Draw plots of phylogenetic tree.
}
\description{
Function to plot phylogenetic tree from the estimated results
}
