% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statement.R
\name{statement}
\alias{statement}
\title{Build Adwords Query Language Statement}
\usage{
statement(select = c("AccountDescriptiveName", "AccountId", "Impressions",
  "Clicks", "Cost", "Date"), report = "ACCOUNT_PERFORMANCE_REPORT", where,
  start = "2017-01-01", end = "2017-01-10")
}
\arguments{
\item{select}{Attributes}

\item{report}{Report type}

\item{where}{Condition list, e.g. "CampaignName STARTS_WITH 'A' AND Clicks > 100",
multiple conditions can be only combined with AND
Operators:  = | != | > | >= | < | <= | IN | NOT_IN | STARTS_WITH | STARTS_WITH_IGNORE_CASE |
CONTAINS | CONTAINS_IGNORE_CASE | DOES_NOT_CONTAIN | DOES_NOT_CONTAIN_IGNORE_CASE}

\item{start}{Beginning of date range. Format: 2016-01-01}

\item{end}{End of date rage. Format: 2016-01-10}
}
\value{
The statement neccessary for the \code{\link{getData}} function.
}
\description{
Generates and builds the Adwords Query Language Statement for querying the Adwords API.
}
\examples{
body <- statement(select=c('CampaignName','Clicks','Cost','Ctr'),
                  report="CAMPAIGN_PERFORMANCE_REPORT",
                  where="CampaignName STARTS_WITH 'A' AND Clicks > 100",
                  start="2016-03-20",
                  end="2016-03-21")
body <- statement(select=c('Criteria','Clicks','Cost','Ctr'),
                  report="KEYWORDS_PERFORMANCE_REPORT",
                  where="Clicks > 100",
                  start="2016-03-20",
                  end="2016-03-21")    
body <- statement(select=c('Clicks','AveragePosition','Cost','Ctr','ClickConversionRate'),
                  report="ACCOUNT_PERFORMANCE_REPORT",
                  start="2016-03-20",
                  end="2016-06-21") 
}
