% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getData.R
\name{getData}
\alias{getData}
\alias{clientCustomerId}
\alias{transformation}
\title{Get Adwords Data}
\usage{
getData(clientCustomerId, google_auth, statement, apiVersion = "201710",
  transformation = TRUE, changeNames = TRUE,
  includeZeroImpressions = FALSE, verbose = FALSE)
}
\arguments{
\item{clientCustomerId}{Adwords Account Id}

\item{google_auth}{list of authentication}

\item{statement}{awql statement generated with \code{\link{statement}}.}

\item{apiVersion}{supports 201702, 201708, 201710 defaults to 201710.}

\item{transformation}{If TRUE, data will be transformed with \code{\link{transformData}} into suitable R dataframe.
Else, the data are returned in raw format.}

\item{changeNames}{If TRUE, the display names of the transformed data are converted into more nicer/practical names. Requires transformation = TRUE}

\item{includeZeroImpressions}{If TRUE zero impressions will be included. Defaults to FALSE.}

\item{verbose}{Defaults to FALSE. If TRUE, the curl connection output will be printed.}
}
\value{
Dataframe with the Adwords Data.
}
\description{
getData posts the Adwords Query Language (awql) Statement which is generated with \code{\link{statement}}.
The data are retrieved from the Adwords API as a dataframe.
}
