% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RbaseXClient.R
\name{BasexClient}
\alias{BasexClient}
\title{BasexClient}
\description{
The client can be used in 'standard' mode and in 'query' mode.
    Standard Mode is used for connecting to a server and sending commands.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{BasexClient$new()}}
\item \href{#method-Execute}{\code{BasexClient$Execute()}}
\item \href{#method-Query}{\code{BasexClient$Query()}}
\item \href{#method-Add}{\code{BasexClient$Add()}}
\item \href{#method-Create}{\code{BasexClient$Create()}}
\item \href{#method-Replace}{\code{BasexClient$Replace()}}
\item \href{#method-Store}{\code{BasexClient$Store()}}
\item \href{#method-bool_test_sock}{\code{BasexClient$bool_test_sock()}}
\item \href{#method-str_receive}{\code{BasexClient$str_receive()}}
\item \href{#method-getSocket}{\code{BasexClient$getSocket()}}
\item \href{#method-clone}{\code{BasexClient$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Initialize a new client-session
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$new(host, port = 1984L, username, password)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host, port, username, password}}{Host-information and user-credentials}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Execute"></a>}}
\subsection{Method \code{Execute()}}{
Execute a command
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$Execute(command)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Command}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
For a list of database commands see \url{http://docs.basex.org/wiki/Commands}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Query"></a>}}
\subsection{Method \code{Query()}}{
Create a new query-object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$Query(query)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query-string}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A query-object has two fields. 'queryObject' is an ID for the new created 'QueryClass'-instance.
    'success' holds the status from the last executed operation on the queryObject.
}

\subsection{Returns}{
ID for the created query-object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Add"></a>}}
\subsection{Method \code{Add()}}{
Add a new resouce at the specified path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$Add(path, input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path}

\item{\code{input}}{File, directory or XML-string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Create"></a>}}
\subsection{Method \code{Create()}}{
Create a new database
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$Create(name, input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name}

\item{\code{input}}{Initial content, Optional}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initial content can be offered as string, URL or file.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Replace"></a>}}
\subsection{Method \code{Replace()}}{
Replace resource, adressed by path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$Replace(path, input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path}

\item{\code{input}}{File, directory or XML-string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Store"></a>}}
\subsection{Method \code{Store()}}{
Store binary content
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$Store(path, input)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Path}

\item{\code{input}}{File, directory or XML-string}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Binary content can be retrieved by executing a retrieve-command
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bool_test_sock"></a>}}
\subsection{Method \code{bool_test_sock()}}{
Return a boolean that indicates the result from the last action on the socket
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$bool_test_sock(socket)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{socket}}{Socket-ID}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-str_receive"></a>}}
\subsection{Method \code{str_receive()}}{
Read a string from a stream
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$str_receive(input, output, bin = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input, output}}{Input- and output-stream}

\item{\code{bin}}{Boolean; TRUE when str_receive has to retrieve binary data}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method is not intented to be called direct. Due to the lack of a 'protected' classifier for R6, this is a 'public' method
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSocket"></a>}}
\subsection{Method \code{getSocket()}}{
Get socket-ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$getSocket()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BasexClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
