% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Domains.R
\name{bitly_pro_domain}
\alias{bitly_pro_domain}
\title{Validate given domain for PRO features}
\usage{
bitly_pro_domain(domain, showRequestURL = FALSE)
}
\arguments{
\item{domain}{- A short domain. ie: nyti.ms.}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug purposes.}
}
\value{
bitly_pro_domain - 0 or 1 designating whether this is a current bitly domain.

domain - an echo back of the request parameter.
}
\description{
Query whether a given domain is a valid bitly pro domain. Keep in mind that bitly custom
short domains are restricted to less than 15 characters in length.
}
\examples{
options(Bit.ly = "0906523ec6a8c78b33f9310e84e7a5c81e500909")
bitly_pro_domain(domain = "nytidsfds.ms")
bitly_pro_domain(domain = "nyti.ms", showRequestURL = TRUE)
}
\seealso{
See \url{http://dev.bitly.com/domains.html#v3_bitly_pro_domain}
}

