% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regu-est.R
\name{ate.nreg}
\alias{ate.nreg}
\title{Model-assisted inference for average treatment effects without regularization}
\usage{
ate.nreg(y, tr, x, ploss = "cal", yloss = "gaus", off = NULL)
}
\arguments{
\item{y}{An \eqn{n} x \eqn{1} vector of observed outcomes.}

\item{tr}{An \eqn{n} x \eqn{1} vector of treatment indicators (=1 if treated or 0 if untreated).}

\item{x}{An \eqn{n} x \eqn{p} matix of covariates, used in both propensity score and outcome regression models.}

\item{ploss}{A loss function used in propensity score estimation (either "ml" or "cal").}

\item{yloss}{A loss function used in outcome regression (either "gaus" for continuous outcomes or "ml" for binary outcomes).}

\item{off}{A \eqn{2} x \eqn{1} vector of offset values (e.g., the true values in simulations) used to calculate the z-statistics from augmented IPW estimation.}
}
\value{
\item{ps}{A list containing the results from fitting the propensity score model by \code{\link{glm.nreg}}.}
\item{mfp}{An \eqn{n} x \eqn{2} matrix of fitted propensity scores for untreated (first column) and treated (second column).}
\item{or}{A list containing the results from fitting the outcome regression model by \code{\link{glm.nreg}}.}
\item{mfo}{An \eqn{n} x \eqn{2} matrix of fitted values from outcome regression, for untreated (first column) and treated (second column).}
\item{est}{A list containing the results from augmented IPW estimation by \code{\link{ate.aipw}}.}
}
\description{
This function implements model-assisted inference for average treatment effects,
using non-regularized calibrated estimation.
}
\details{
For calibrated estimation, two sets of propensity scores are separately estimated for the untreated and treated as discussed in Tan (2017, 2019).
See also \strong{Details} for \code{\link{mn.nreg}}.
}
\examples{
data(simu.data)
n <- dim(simu.data)[1]
p <- dim(simu.data)[2]-2

y <- simu.data[,1]
tr <- simu.data[,2]
x <- simu.data[,2+1:p]
x <- scale(x)

# include only 10 covariates
x2 <- x[,1:10]

ate.cal <- ate.nreg(y, tr, x2, ploss="cal", yloss="gaus")
matrix(unlist(ate.cal$est), ncol=2, byrow=TRUE,
dimnames=list(c("one", "ipw", "or", "est", "var", "ze", 
"diff.est", "diff.var", "diff.ze"), c("untreated", "treated")))

}
\references{
Tan, Z. (2017) Regularized calibrated estimation of propensity scores with model misspecification and high-dimensional data, arXiv:1710.08074. 

Tan, Z. (2019) Model-assisted inference for treatment effects using regularized calibrated estimation with high-dimensional data, 
\emph{Annals of Statistics}, to appear (preprint arXiv:1801.09817).
}
