% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{beta_true_heterogroups}
\alias{beta_true_heterogroups}
\title{Helpfunction in create_true_beta() for the option beta_true_heterogeneous_groups. (This is the default option.)}
\usage{
beta_true_heterogroups(
  vars,
  S_true,
  extra_beta_factor = 1,
  limit_true_groups = 12
)
}
\arguments{
\item{vars}{number of observable variables}

\item{S_true}{true number of groups: should be at least 1 and maximum limit_true_groups}

\item{extra_beta_factor}{option to multiply the coefficients in true beta; default = 1}

\item{limit_true_groups}{Maximum number of true groups in a simulation-DGP for which the code in this package is implemented. Currently equals 12. For application on realworld data this parameter is not relevant.}
}
\value{
matrix where the number of rows equals S_true, and the number of columns equals max(1, vars)
}
\description{
Helpfunction in create_true_beta() for the option beta_true_heterogeneous_groups. (This is the default option.)
}
