\name{export_genclone}
\alias{export_genclone_genind}
\alias{export_genclone_genetix}
\alias{export_genclone_arlequin}

\title{
export data file to Adegent, Genetix and Arlequin
}

\description{
These functions allow to transform a \command{RClone} table into files to work 
with \command{Adegenet} (R package), Genetix and Arlequin softwares.
}

\usage{
export_genclone_genind(data1, ele)
export_genclone_genetix(data1, haploid = FALSE, ele, name)
export_genclone_arlequin(data1, haploid = FALSE, name)
}

\arguments{
  \item{data1}{
a \command{RClone} table with only one population.
}
  \item{haploid}{
logical, option, if \command{haploid = FALSE}, \command{data1} contains diploid data;
 if \command{haploid} = TRUE, haploid data.
}
  \item{ele}{
option, separator element for export.
}
  \item{name}{
option, name of the exported file.
}
}

\value{
a \command{genind} object or a file for Genetix or Arlequin.
}

\author{
The R implementation of \command{RClone} was written by Diane Bailleul working for Sophie Arnaud-Haond at IFREMER.


The design was inspired by GenClone program described in Arnaud-Haond & Belkhir (2007).


Maintainer: Diane Bailleul <diane.bailleul@gmail.com>


Author: Sophie Arnaud-Haond <sohie.arnaud@ifremer.fr>
}

\note{
For multi-population files, we recommend to use split function to cut the table into 
several tables, one for each population, and then combine \command{lapply} with the export functions.
}

\examples{

data(posidonia)

#RClone to Adegenet:
res <- export_genclone_genind(posidonia, "/")
#library(adegenet)
#res2 <- df2genind(res, ploidy = 2, sep = "/")
#res2$loc.nall

#RClone to Genetix:
export_genclone_genetix(posidonia, name = "test.txt")
#or
write.table(export_genclone_genetix(posidonia), "test2.txt", row.names = FALSE, 
sep = "\t", quote = FALSE)
#for genets only:
export_genclone_genetix(unique(posidonia), name = "test.txt")

#Rclone to Arlequin:
write.table(export_genclone_arlequin(posidonia), "file1.arp", row.names = FALSE,
 col.names = FALSE, quote = FALSE)
#or
export_genclone_arlequin(posidonia, haploid = FALSE, "file2.arp")
#for genets only:
export_genclone_arlequin(unique(posidonia), haploid = FALSE, "file2.arp")

#if several populations:
#res <- split(data, vecpop)
#lapply(res, function(x) export_genclone_genetix(x))
#lapply(res, function(x) export_genclone_arlequin(x))
}

\keyword{documentation}
