% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipseToConicMatrix.R
\name{ellipseToConicMatrix}
\alias{ellipseToConicMatrix}
\title{Transformation of the ellipse parameters into the matrix representation}
\usage{
ellipseToConicMatrix(saxes = c(1, 1), loc = c(0, 0), theta = 0)
}
\arguments{
\item{saxes}{a \eqn{(2 \times 1)} vector of the length of the
ellipse semi-axes.}

\item{loc}{a \eqn{(2 \times 1)} vector of the Cartesian coordinates of 
the ellipse center.}

\item{theta}{the angle of rotation of the ellipse (in radians).}
}
\value{
A \eqn{(3 \times 3)} matrix that represents the ellipse.
}
\description{
Transformation of the ellipse parameters (Cartesian coordinates of the 
ellipse center, length of the semi-axes and angle of rotation) into the 
\eqn{(3 \times 3)} into the matrix representation of conics.
}
\examples{
# Ellipse parameters
saxes <- c(5,2)
loc <- c(0,0)
theta <- pi/4
# Matrix representation of the ellipse
C <- ellipseToConicMatrix(saxes,loc,theta)
}
\seealso{
\code{\link{conicMatrixToEllipse}}
}
