% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redcap-project.R
\docType{class}
\name{redcap_project}
\alias{redcap_project}
\title{A \code{Reference Class} to make later calls to REDCap more convenient.}
\description{
This \code{Reference Class} represents a REDCap project.
Once some values are set that are specific to a REDCap project (such as the URI and token),
later calls are less verbose (such as reading and writing data).  The functionality
}
\section{Fields}{

\describe{
\item{\code{redcap_uri}}{The URI (uniform resource identifier) of the REDCap project.  Required.}

\item{\code{token}}{token The user-specific string that serves as the password for a project.  Required.}
}}

\section{Methods}{

\describe{
\item{\code{read(batch_size = 100L, interbatch_delay = 0, records = NULL,
  records_collapsed = "", fields = NULL, fields_collapsed = "",
  export_data_access_groups = FALSE, raw_or_label = "raw", verbose = TRUE,
  config_options = NULL)}}{Exports records from a REDCap project.}

\item{\code{write(ds_to_write, batch_size = 100L, interbatch_delay = 0,
  verbose = TRUE, config_options = NULL)}}{Imports records to a REDCap project.}
}}

\examples{
library(REDCapR) #Load the package into the current R session.
uri <- "https://bbmc.ouhsc.edu/redcap/api/"
token <- "D70F9ACD1EDD6F151C6EA78683944E98"
\dontrun{
project <- redcap_project$new(redcap_uri=uri, token=token)
ds_all <- project$read()

#Demonstrate how repeated calls are more concise when the token and url aren't always passed.
ds_three_columns <- project$read(fields=c("record_id", "sex", "height"))$data

ids_of_males vv <- ds_three_columns$record_id[ds_three_columns$sex==1]
ids_of_shorties <- ds_three_columns$record_id[ds_three_columns$height < 40]

ds_males        <- project$read(records=ids_of_males, batch_size=2)$data
ds_shorties     <- project$read(records=ids_of_shorties)$data

#Switch the Genders
sex_original         <- ds_three_columns$sex
ds_three_columns$sex <- (1 - ds_three_columns$sex)
project$write(ds_three_columns)

#Switch the Genders back
ds_three_columns$sex <- sex_original
project$write(ds_three_columns)
}
}
