% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{REMAP_SplitProbeSets}
\alias{REMAP_SplitProbeSets}
\title{"REMAP_SplitProbeSets"}
\usage{
REMAP_SplitProbeSets(Data, REMAPSplitFile, NotAnnotated = FALSE,
  Location = NULL, Name = "REMAP")
}
\arguments{
\item{Data}{The data frame to be transformed.}

\item{REMAPSplitFile}{The name of the file with the REMAP information regarding the split of the probe sets if the TC ID is annotated to mutiple genes.}

\item{NotAnnotated}{Logical. Should the probe sets which are not annotated to a gene still be included? If FALSE, these are excluded. If TRUE, these are included. Default is FALSE.}

\item{Location}{The location where the file should be saved. If NULL, the object is returned to the user. Otherwise, a file with the specified name is created.}

\item{Name}{The name of the output file. Defaults to "REMAP".}
}
\value{
A data frame with similar information as the data frame specified in Data with an altered gene ID (first) column in order to match the REMAP annotation.
}
\description{
The REMAP_SplitProbeSets function converts the original data frame to a data frame based on the retrieved REMAP annotation.
}
\examples{
\dontrun{
data(TC1500264)

REMAPTest=REMAP_SplitProbeSets(Data=TC1500264,REMAPSplitFile=
"TC1500264_Gene_Split.txt")
}
}
