% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotSAEM}
\alias{plotSAEM}
\title{Display the value of parameters at each iteration}
\usage{
plotSAEM(fit, paramToPlot = "all", trueValue = NULL)
}
\arguments{
\item{fit}{object of class remix, from \code{\link{remix}} or a certain build from \code{\link{cv.remix}} output.}

\item{paramToPlot}{Population parameters to plot (which have been estimated by SAEM) ;}

\item{trueValue}{(for simulation purpose) vector named of true values ;}
}
\value{
For each parameters, the values at the end of each iteration of remix algorithm is drawn. Moreover, the SAEM steps of each iteration are displayed.
}
\description{
Display the value of parameters at each iteration
}
\examples{
\dontrun{
project <- getMLXdir()

ObsModel.transfo = list(S=list(AB=log10),
                        linkS="yAB",
                        R=rep(list(S=function(x){x}),5),
                        linkR = paste0("yG",1:5))

alpha=list(alpha0=NULL,
           alpha1=setNames(paste0("alpha_1",1:5),paste0("yG",1:5)))

y = c(S=5,AB=1000)
lambda = 1440

res = remix(project = project,
            dynFUN = dynFUN_demo,
            y = y,
            ObsModel.transfo = ObsModel.transfo,
            alpha = alpha,
            selfInit = TRUE,
            eps1=10**(-2),
            eps2=1,
            lambda=lambda)

plotConvergence(res)

trueValue = read.csv(paste0(dirname(project),"/demoSMLX/Simulation/populationParameters.txt"))

plotSAEM(res,paramToPlot = c("delta_S_pop","phi_S_pop","delta_AB_pop"),trueValue=trueValue)
}
}
\seealso{
\code{\link{remix}}, \code{\link{cv.remix}}.
}
