% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S2d.R
\name{S2d}
\alias{S2d}
\title{Convert S to Cohen's d}
\usage{
S2d(S, pi = 0.5)
}
\arguments{
\item{S}{Numeric, the robust effect size index.}

\item{pi}{Numeric, the sampling proportions.}
}
\value{
Returns an estimate of Cohen's \emph{d} based on the RESI.
}
\description{
Converts the robust effect size index (S) to Cohen's d using the formula from
Vandekar, Rao, & Blume (2020).
}
\details{
The pi parameter comes from the fact that Cohen's d doesn't account
for unequal sample proportions in the population, but S does.

The default is set to a natural value 1/2, which corresponds to a case
control design, for example, where sampling proportions always are
controlled by the experimenter.

The formula for the conversion is:

\eqn{ d = | S * \sqrt(1/\pi + 1/(1 - \pi)) |}
}
\examples{
# fit a simple linear regression with a binary predictor
mod = lm(charges ~ sex, data = RESI::insurance)

# calculate t-value
t = summary(mod)$coefficients[2, "t value"]

# calculate RESI (S)
S = t2S(t, n = 1338, rdf = 1336)

# determine sample proportions
pi = length(which(RESI::insurance[,"sex"]=="male"))/1338

# convert S to Cohen's d
S2d(S = S, pi = pi)

}
