% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t2S_alt.R
\name{t2S_alt}
\alias{t2S_alt}
\title{Compute the robust effect size index estimate from t statistic (alternative)}
\usage{
t2S_alt(t, rdf, n)
}
\arguments{
\item{t}{The t statistic for the parameter of interest.}

\item{rdf}{Model residual degrees of freedom or number of independent samples.}

\item{n}{Number of independent samples.}
}
\value{
Returns a scalar or vector argument of the the robust effect size index estimate.
}
\description{
This function computes the robust effect size index from Vandekar, Rao, & Blume (2020).
Vector arguments are accepted. If different length arguments are passed they are dealt with in the usual way of R.
}
\details{
This function computes S, the RESI, from a T statistic using the alternative
formula. There is another function, \code{\link{t2S}}, that is the default for
\code{\link{resi}}. This function's formula is derived by squaring the T statistic
and using the \code{\link{f2S}} formula. This function may be appealing for its
intuitive relationship to the F statistic; the absolute value of RESI estimates
using this formula will be equal to a RESI estimate using an F statistic for
the same model. However, this estimator does have finite sample bias, which is an
important consideration for the coverage of the bootstrapping that \code{resi} uses.

The formula for this conversion is:

\eqn{ \sqrt(max(0, (t^2 * (rdf - 2)/rdf - 1)/rdf))}
}
\examples{
# to obtain t values, first fit a lm
mod = lm(charges ~ region * age + bmi + sex, data = RESI::insurance)
# run lmtest::coeftest to get t values, using a robust variance-covariance formula
ts = lmtest::coeftest(mod, vcov. = sandwich::vcovHC)[,'t value']

# get RESI estimates
t2S_alt(ts, rdf = mod$df.residual, n = nrow(RESI::insurance))
}
