% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rforcecom.closeBulkJob.R
\name{rforcecom.closeBulkJob}
\alias{rforcecom.closeBulkJob}
\title{Close Bulk API Job}
\usage{
rforcecom.closeBulkJob(session, jobId)
}
\arguments{
\item{session}{a named character vector defining parameters of the api connection as returned by \link{rforcecom.login}}

\item{jobId}{a character string defining the salesforce id assigned to a submitted job as returned by \link{rforcecom.createBulkJob}}
}
\value{
A \code{list} of parameters defining the now closed job
}
\description{
This function closes a Job in the Salesforce Bulk API
}
\examples{
\dontrun{
job_close_info <- rforcecom.closeBulkJob(session, jobId=job_info$id)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
\concept{
bulk job salesforce api
}

