/*
 * Decompiled with CFR 0.152.
 */
package freak.core.fitness;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractSingleObjectiveFitnessFunction;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;

public abstract class AbstractStaticSingleObjectiveFitnessFunction
extends AbstractSingleObjectiveFitnessFunction
implements SingleObjectiveFitnessFunction {
    public AbstractStaticSingleObjectiveFitnessFunction(Schedule schedule) {
        super(schedule);
    }

    public final double evaluate(Individual individual, IndividualList list) {
        Double[] d = individual.getLatestKnownFitnessValue();
        if (d != null) {
            return d[0];
        }
        double fitness = this.evaluate(individual.getPhenotype());
        Double[] result = new Double[]{new Double(fitness)};
        individual.setLatestKnownFitnessValue(result);
        return fitness;
    }

    protected abstract double evaluate(Genotype var1);

    public int compareIndividuals(Individual ind1, Individual ind2) throws UnsupportedOperationException {
        double f2;
        if (ind1 == ind2) {
            return 0;
        }
        double f1 = this.evaluate(ind1, null);
        if (f1 > (f2 = this.evaluate(ind2, null))) {
            return 1;
        }
        if (f1 < f2) {
            return -1;
        }
        return 0;
    }
}

