/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.branchandbound.tsp.constant;

import edu.ucsb.cs.jicos.applications.branchandbound.tsp.AbstractSolution;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.Q;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.constant.TSP;
import edu.ucsb.cs.jicos.services.Environment;
import edu.ucsb.cs.jicos.services.Shared;
import edu.ucsb.cs.jicos.services.Task;

class TspSolution
extends AbstractSolution {
    static final int COMPLETE_THRESHOLD = 1;
    static final int ATOMIC = 11;
    private int[] nodes;
    private int length;
    private int lowerBound;
    private boolean symmetric = true;
    private boolean equivalenceUnknown = true;

    TspSolution(TspSolution tspSolution, int n) {
        this.nodes = new int[tspSolution.nodes.length];
        System.arraycopy(tspSolution.nodes, 0, this.nodes, 0, tspSolution.nodes.length);
        this.length = tspSolution.length;
        this.lowerBound = tspSolution.lowerBound;
        this.equivalenceUnknown = tspSolution.equivalenceUnknown;
        if (this.equivalenceUnknown && this.nodes[n] == 1) {
            this.equivalenceUnknown = false;
        }
        int n2 = this.nodes[this.length];
        this.nodes[this.length++] = this.nodes[n];
        this.nodes[n] = n2;
    }

    public TspSolution(int n) {
        this.nodes = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.nodes[n2] = n2;
            ++n2;
        }
        this.length = 1;
    }

    public void computeLowerBound(Environment environment) {
        TSP tSP = (TSP)environment.getInput();
        this.lowerBound += tSP.distance[this.nodes[this.length - 2]][this.nodes[this.length - 1]];
        if (this.isComplete(environment)) {
            ++this.length;
            this.lowerBound += tSP.distance[this.nodes[this.nodes.length - 2]][this.nodes[this.nodes.length - 1]];
            this.lowerBound += tSP.distance[this.nodes[this.nodes.length - 1]][0];
        }
    }

    public Q getChildren(Environment environment) {
        Shared shared = environment.getShared();
        Q q = new Q();
        int n = this.length;
        while (n < this.nodes.length) {
            if (!this.symmetric || !this.equivalenceUnknown || this.nodes[n] != 2) {
                TspSolution tspSolution = new TspSolution(this, n);
                tspSolution.computeLowerBound(environment);
                int n2 = (Integer)shared.get();
                if (tspSolution.lowerBound < n2) {
                    q.add(tspSolution);
                }
            }
            ++n;
        }
        return q;
    }

    public int getLowerBound(Environment environment) {
        return this.lowerBound;
    }

    public boolean isAtomic(Task task) {
        return this.nodes.length - this.length < 11;
    }

    public boolean isComplete(Environment environment) {
        return this.nodes.length - this.length <= 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Size: " + this.nodes.length + ", tour size: " + this.length);
        stringBuffer.append(", cost: " + this.lowerBound + ", Tour: ");
        int n = 0;
        while (n < this.length) {
            stringBuffer.append(" ").append(this.nodes[n]);
            ++n;
        }
        return new String(stringBuffer);
    }
}

