/*
 * Decompiled with CFR 0.152.
 */
package freak.core.view;

import freak.core.control.Schedule;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.inspector.StringArrayWrapper;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.view.AbstractView;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.UpdateManager;
import javax.swing.JPanel;

public abstract class SingleIndividualView
extends AbstractView
implements FreakSwingModel,
Configurable {
    private transient JPanel individualPanel;
    private IndividualList individuals;
    private Individual individual;
    private int displayStrategy = 2;
    private int indexToDisplay = 0;
    public static final int AUTO_CYCLE = 0;
    public static final int RANDOM = 1;
    public static final int FIXED_INDEX = 2;

    public SingleIndividualView(Schedule schedule) {
        super(schedule);
    }

    public final JPanel createPanel() {
        this.individualPanel = this.createIndividualPanel();
        return this.individualPanel;
    }

    public abstract JPanel createIndividualPanel();

    public Class[] getInputDataTypes() {
        return new Class[]{IndividualList.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(Object data) {
        super.update(data);
        SingleIndividualView singleIndividualView = this;
        synchronized (singleIndividualView) {
            this.individuals = (IndividualList)data;
            this.individual = this.chooseIndividual();
        }
        UpdateManager.markDirty(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.individualPanel == null) {
            return;
        }
        SingleIndividualView singleIndividualView = this;
        synchronized (singleIndividualView) {
            this.individualPanel.repaint();
        }
    }

    public Individual getIndividualToDisplay() {
        return this.individual;
    }

    private Individual chooseIndividual() {
        if (this.individuals == null || this.individuals.isEmpty()) {
            return null;
        }
        switch (this.displayStrategy) {
            case 0: {
                this.indexToDisplay = (this.indexToDisplay + 1) % this.individuals.size();
                break;
            }
            case 1: {
                this.indexToDisplay = this.getSchedule().getRandomElement().choose(this.individuals.size() - 1);
            }
        }
        if (this.indexToDisplay >= this.individuals.size()) {
            this.indexToDisplay = 0;
        }
        return this.individuals.getIndividual(this.indexToDisplay);
    }

    public IndividualList getIndividualList() {
        return this.individuals;
    }

    public int getDisplayStrategy() {
        return this.displayStrategy;
    }

    public void setDisplayStrategy(int i) {
        this.displayStrategy = i;
    }

    public void setPropertyDisplayStrategy(StringArrayWrapper saw) {
        this.displayStrategy = saw.getIndex();
    }

    public StringArrayWrapper getPropertyDisplayStrategy() {
        String[] strings = new String[]{"Auto cycle", "Random", "Fixed index"};
        return new StringArrayWrapper(strings, this.displayStrategy);
    }

    public String getShortDescriptionForDisplayStrategy() {
        return "Display strategy";
    }

    public String getLongDescriptionForDisplayStrategy() {
        return "The strategy used to determine the displayed individual. Choices are to permanently cycle through the indices of the population, to choose an individual randomly or to display the individual at a fixed index.";
    }

    public void setPropertyIndexToDisplay(Integer i) {
        this.indexToDisplay = i;
    }

    public Integer getPropertyIndexToDisplay() {
        return new Integer(this.indexToDisplay);
    }

    public String getShortDescriptionForIndexToDisplay() {
        return "Index to display";
    }

    public String getLongDescriptionForIndexToDisplay() {
        return "The index of the individual to display, i.e. the position within the population. The index is determined by the display strategy in every step.";
    }
}

