/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;

public class BasicMarqueeHandler {
    protected transient Cursor previousCursor = null;
    protected Rectangle marqueeBounds;
    protected Point startPoint;
    protected Point currentPoint;

    public boolean isForceMarqueeEvent(MouseEvent mouseEvent) {
        return mouseEvent.isAltDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            if (mouseEvent != null && !mouseEvent.isConsumed() && this.marqueeBounds != null) {
                if (!(mouseEvent.getSource() instanceof JGraph)) {
                    throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
                }
                JGraph jGraph = (JGraph)mouseEvent.getSource();
                Rectangle rectangle = jGraph.fromScreen(new Rectangle(this.marqueeBounds));
                CellView[] cellViewArray = jGraph.getGraphLayoutCache().getRoots(rectangle);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n = 0;
                while (n < cellViewArray.length) {
                    if (rectangle.contains(cellViewArray[n].getBounds())) {
                        arrayList.add(cellViewArray[n].getCell());
                    }
                    ++n;
                }
                Object[] objectArray = arrayList.toArray();
                jGraph.getUI().selectCellsForEvent(jGraph, objectArray, mouseEvent);
                jGraph.setCursor(this.previousCursor);
                Rectangle rectangle2 = new Rectangle(this.marqueeBounds);
                ++rectangle2.width;
                ++rectangle2.height;
                jGraph.repaint(rectangle2);
                mouseEvent.consume();
            }
        }
        finally {
            this.currentPoint = null;
            this.startPoint = null;
            this.marqueeBounds = null;
            this.previousCursor = null;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && this.startPoint != null) {
            if (!(mouseEvent.getSource() instanceof JGraph)) {
                throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
            }
            JGraph jGraph = (JGraph)mouseEvent.getSource();
            Graphics graphics = jGraph.getGraphics();
            Color color = jGraph.getBackground();
            Color color2 = jGraph.getMarqueeColor();
            graphics.setColor(color2);
            graphics.setXORMode(color);
            this.overlay(graphics);
            this.currentPoint = mouseEvent.getPoint();
            this.marqueeBounds = new Rectangle(this.startPoint);
            this.marqueeBounds.add(this.currentPoint);
            graphics.setColor(color);
            graphics.setXORMode(color2);
            this.overlay(graphics);
            mouseEvent.consume();
        }
    }

    public void paint(Graphics graphics) {
        this.overlay(graphics);
    }

    protected void overlay(Graphics graphics) {
        if (this.marqueeBounds != null) {
            graphics.drawRect(this.marqueeBounds.x, this.marqueeBounds.y, this.marqueeBounds.width, this.marqueeBounds.height);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            if (!(mouseEvent.getSource() instanceof JGraph)) {
                throw new IllegalArgumentException("MarqueeHandler cannot handle event from unknown source: " + mouseEvent);
            }
            JGraph jGraph = (JGraph)mouseEvent.getSource();
            this.startPoint = mouseEvent.getPoint();
            this.marqueeBounds = new Rectangle(this.startPoint);
            this.previousCursor = jGraph.getCursor();
            jGraph.setCursor(new Cursor(1));
            mouseEvent.consume();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Point getCurrentPoint() {
        return this.currentPoint;
    }

    public Rectangle getMarqueeBounds() {
        return this.marqueeBounds;
    }

    public Cursor getPreviousCursor() {
        return this.previousCursor;
    }

    public Point getStartPoint() {
        return this.startPoint;
    }

    public void setCurrentPoint(Point point) {
        this.currentPoint = point;
    }

    public void setMarqueeBounds(Rectangle rectangle) {
        this.marqueeBounds = rectangle;
    }

    public void setPreviousCursor(Cursor cursor) {
        this.previousCursor = cursor;
    }

    public void setStartPoint(Point point) {
        this.startPoint = point;
    }
}

