/*
 * Decompiled with CFR 0.152.
 */
package freak.module.searchspace;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.core.searchspace.AbstractSearchSpace;
import freak.core.searchspace.HasDimension;
import freak.module.searchspace.PermutationGenotype;

public class Permutation
extends AbstractSearchSpace
implements Configurable,
HasDimension {
    private int dimension = 40;

    public Permutation(Schedule schedule) {
        super(schedule);
    }

    public String getName() {
        return "Permutation";
    }

    public String getDescription() {
        return "Represents all permutations in the symmetric group S_{dimension}. \nThat are all permutations of the elements {1,...,dimension}.";
    }

    private double factorial(int n) {
        if (n == 1) {
            return 1.0;
        }
        return (double)n * this.factorial(n - 1);
    }

    public double getSize() {
        if (this.dimension > 170) {
            return Double.POSITIVE_INFINITY;
        }
        return this.factorial(this.dimension);
    }

    public Genotype getRandomGenotype() {
        int[] gt = new int[this.dimension];
        RandomElement re = this.schedule.getRandomElement();
        int i = 0;
        while (i < this.dimension) {
            gt[i] = i + 1;
            ++i;
        }
        i = 0;
        while (i < this.dimension - 1) {
            int j = re.choose(i, this.dimension - 1);
            int tmp = gt[i];
            gt[i] = gt[j];
            gt[j] = tmp;
            ++i;
        }
        return new PermutationGenotype(gt);
    }

    public String getLongDescriptionForDimension() {
        return "Elements in this search space are permutations in the symmetric group S_{dimension}.";
    }

    public void setPropertyDimension(Integer dim) {
        if (dim > 1) {
            this.dimension = dim;
        }
    }

    public Integer getPropertyDimension() {
        return new Integer(this.dimension);
    }

    public int getDimension() {
        return this.dimension;
    }
}

