/*
 * Decompiled with CFR 0.152.
 */
package freak.core.control;

import java.io.Serializable;

class TimeController
implements Serializable {
    private double accumulatedRunTime;
    private double accumulatedProcessingTime;
    private boolean running;
    private boolean inTimeOut;
    private long periodStartTime;
    private long timeOutStart;
    private long periodWaitTime;
    private double generationsPerSecond;
    private double aheadOfTime = 0.0;
    private long lastGenerationStart = 0L;

    TimeController() {
    }

    double getRuntime() {
        return this.accumulatedRunTime + this.getPeriodRunTime();
    }

    double getProcessingTime() {
        return this.accumulatedProcessingTime + this.getPeriodProcessingTime();
    }

    double getPeriodRunTime() {
        if (this.running) {
            return (double)(System.currentTimeMillis() - this.periodStartTime) / 1000.0;
        }
        return 0.0;
    }

    double getPeriodProcessingTime() {
        if (this.running) {
            return (double)(System.currentTimeMillis() - this.periodStartTime - this.periodWaitTime) / 1000.0;
        }
        return 0.0;
    }

    void startCounting() {
        this.periodStartTime = System.currentTimeMillis();
        this.periodWaitTime = 0L;
        this.lastGenerationStart = 0L;
        this.aheadOfTime = 0.0;
        this.running = true;
    }

    void stopCounting() {
        if (!this.running) {
            return;
        }
        if (this.inTimeOut) {
            this.timeOutStop();
        }
        long now = System.currentTimeMillis();
        double runTime = (double)(now - this.periodStartTime) / 1000.0;
        double processingTime = (double)(now - this.periodStartTime - this.periodWaitTime) / 1000.0;
        this.accumulatedRunTime += Math.max(0.0, runTime);
        this.accumulatedProcessingTime += Math.max(0.0, processingTime);
        this.running = false;
    }

    void timeOutStart() {
        if (!this.running) {
            return;
        }
        this.timeOutStart = System.currentTimeMillis();
        this.inTimeOut = true;
    }

    void timeOutStop() {
        if (!this.running) {
            return;
        }
        long timeOut = System.currentTimeMillis() - this.timeOutStart;
        this.periodWaitTime += timeOut;
        this.inTimeOut = false;
    }

    void setSpeedLimit(double generationsPerSecond) {
        if (generationsPerSecond != this.generationsPerSecond) {
            this.aheadOfTime = 0.0;
            this.generationsPerSecond = generationsPerSecond;
        }
    }

    void nextGeneration(Object waitOn) {
        if (this.lastGenerationStart == 0L) {
            this.lastGenerationStart = System.currentTimeMillis();
        } else {
            long entryTime = System.currentTimeMillis();
            double duration = (double)(entryTime - this.lastGenerationStart) / 1000.0;
            this.lastGenerationStart = entryTime;
            this.aheadOfTime += 1.0 / this.generationsPerSecond - duration;
            if (this.aheadOfTime > 0.05) {
                long pause = (long)(this.aheadOfTime * 1000.0);
                try {
                    waitOn.wait(pause);
                }
                catch (InterruptedException exc) {
                    Thread.currentThread().interrupt();
                }
                long reallyWaited = System.currentTimeMillis() - entryTime;
                this.periodWaitTime += reallyWaited;
            } else if (this.aheadOfTime < -0.3) {
                this.aheadOfTime = -0.3;
            }
        }
    }
}

