/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.Freak;
import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.MultiObjectiveFitnessFunction;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Module;
import freak.core.modulesupport.ModuleCollector;
import freak.core.modulesupport.inspector.StringArrayWrapper;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.postprocessor.Postprocessor;
import freak.module.fitness.booleanfunction.GenericPareto;
import freak.module.searchspace.BooleanFunction;
import freak.module.searchspace.BooleanFunctionGenotype;
import freak.module.searchspace.logictree.Data;
import freak.rinterface.model.IndividualSummary;
import freak.rinterface.model.RReturns;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public class ResultObserver
extends AbstractObserver
implements RunEventListener,
Configurable {
    private String testDataPath = "";
    String[] postprocessorNames;
    private int postprocessor = 0;
    private Module[] postprocessors;
    private Postprocessor selectedProcessor;
    private boolean selectPostprocessorFromGui = true;

    public boolean isSelectPostprocessorFromGui() {
        return this.selectPostprocessorFromGui;
    }

    public void setSelectPostprocessorFromGui(boolean selectPostprocessorFromGui) {
        this.selectPostprocessorFromGui = selectPostprocessorFromGui;
    }

    public ResultObserver(Schedule schedule) {
        super(schedule);
        ModuleCollector moduleCollector = new ModuleCollector(schedule);
        this.postprocessors = moduleCollector.getPostprocessors(schedule.getGenotypeSearchSpace());
        this.postprocessorNames = new String[this.postprocessors.length + 1];
        this.postprocessorNames[0] = "-";
        int i = 1;
        while (i <= this.postprocessors.length) {
            this.postprocessorNames[i] = this.postprocessors[i - 1].getName();
            ++i;
        }
        this.setMeasure(2);
    }

    public Class getOutputDataType() {
        return Result.class;
    }

    public String getName() {
        return "Result";
    }

    public String getDescription() {
        return "Gives the final individuals of all runs. There is the possibility to do a rework of the individuals after each batch.";
    }

    public void runFinalize(RunEvent evt) {
        Result summary;
        block5: {
            summary = new Result();
            summary.setTestDataPath(this.testDataPath);
            IndividualList lastPopulation = this.getSchedule().getPopulationManager().getPopulation();
            if (this.postprocessor != 0 && this.selectPostprocessorFromGui) {
                this.selectedProcessor = (Postprocessor)this.postprocessors[this.postprocessor - 1];
            }
            try {
                summary.setBestIndividuals(lastPopulation.getAllIndividualsWithRank(1));
                if (this.postprocessor != 0) {
                    this.selectedProcessor.addAllIndividuals(this.getSchedule(), lastPopulation.getAllIndividualsWithRank(1));
                }
            }
            catch (Exception e) {
                if (!(this.schedule.getFitnessFunction() instanceof MultiObjectiveFitnessFunction)) break block5;
                summary.setBestIndividuals(lastPopulation);
                if (this.postprocessor == 0) break block5;
                this.selectedProcessor.addAllIndividuals(this.getSchedule(), lastPopulation);
            }
        }
        summary.setNumberOfGenerations(this.getSchedule().getCurrentGeneration());
        summary.setRunNumber(evt.getRunIndex().run);
        if (this.postprocessor != 0 && this.getSchedule().isLastRunInBatch()) {
            this.selectedProcessor.analyse();
            this.selectedProcessor.reset();
        }
        this.updateViews(summary);
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
    }

    public void setPropertyTestData(String testDataPath) {
        this.testDataPath = testDataPath;
    }

    public String getPropertyTestData() {
        return this.testDataPath;
    }

    public String getShortDescriptionForTestData() {
        return "(BFG only) Path to test data";
    }

    public String getLongDescriptionForTestData() {
        return "(Boolean functions only) Path to test data";
    }

    public void setPropertyPostprocessor(StringArrayWrapper saw) {
        this.postprocessor = saw.getIndex();
    }

    public StringArrayWrapper getPropertyPostprocessor() {
        return new StringArrayWrapper(this.postprocessorNames, this.postprocessor);
    }

    public String getShortDescriptionForPostprocessor() {
        return "Postprocessor";
    }

    public String getLongDescriptionForPostprocessor() {
        return "Should the indivduals of a batch be postprocessed?";
    }

    public void setSelectedProcessor(Postprocessor selectedProcessor) {
        this.selectedProcessor = selectedProcessor;
    }

    public void setPostprocessor(int postprocessor) {
        this.postprocessor = postprocessor;
    }

    public class Result
    implements Serializable {
        private int runNumber;
        private int numberOfGenerations;
        private IndividualList bestIndividuals;
        private String testDataPath;

        public int getNumberOfGenerations() {
            return this.numberOfGenerations;
        }

        public void setNumberOfGenerations(int i) {
            this.numberOfGenerations = i;
        }

        public IndividualList getBestIndividuals() {
            return this.bestIndividuals;
        }

        public void setBestIndividuals(IndividualList individuals) {
            this.bestIndividuals = individuals;
        }

        public String toString() {
            int runs;
            Freak.debug("Trying to write to a log file.", 3);
            StringBuffer s = new StringBuffer();
            FitnessFunction fitness = ResultObserver.this.getSchedule().getFitnessFunction();
            boolean singleObjective = fitness instanceof SingleObjectiveFitnessFunction;
            int n = runs = !Data.csvDisable && this.testDataPath.equals("") || Data.csvDisable && Data.testData == null ? 1 : 2;
            if (this.getRunNumber() == 1) {
                if (runs == 2) {
                    s.append("Data set , ");
                }
                s.append("Run , Generation , No of generations , ");
                if (singleObjective) {
                    s.append("Objective value , ");
                } else {
                    int objectives = ((MultiObjectiveFitnessFunction)fitness).getDimensionOfObjectiveSpace();
                    int j = 1;
                    while (j <= objectives) {
                        s.append("Objective value " + j + ", ");
                        ++j;
                    }
                }
                s.append("Individual\n");
            }
            int k = 0;
            while (k < runs) {
                if (runs == 2) {
                    if (k == 1) {
                        if (Data.csvDisable) {
                            Data.setRData(Data.trainingData);
                            RReturns.setAllMCRinTrainingData(new Vector<IndividualSummary>());
                        } else {
                            Data.setDataLocation(((BooleanFunction)ResultObserver.this.schedule.getGenotypeSearchSpace()).getPropertyInputPath());
                        }
                    } else if (Data.csvDisable) {
                        Data.setRData(Data.testData);
                        RReturns.setAllMCRinTestData(new Vector<IndividualSummary>());
                    } else {
                        Data.setDataLocation(this.testDataPath);
                    }
                    try {
                        Data.readData();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                Iterator i = this.getBestIndividuals().iterator();
                while (i.hasNext()) {
                    Individual individual = (Individual)i.next();
                    if (runs == 2 && individual.getGenotype() instanceof BooleanFunctionGenotype) {
                        individual.setLatestKnownFitnessValue(null);
                        ((BooleanFunctionGenotype)individual.getGenotype()).getDnfbaum().update();
                        if (Data.csvDisable) {
                            if (k == 1) {
                                s.append("training , ");
                            } else {
                                s.append("test , ");
                            }
                        } else {
                            s.append(String.valueOf(Data.getDataLocation()) + " , ");
                        }
                    }
                    if (Data.csvDisable && individual.getGenotype() instanceof BooleanFunctionGenotype) {
                        int length = ((BooleanFunctionGenotype)individual.getGenotype()).evaluateSize();
                        double mcr = 100.0 * (1.0 - (double)((BooleanFunctionGenotype)individual.getGenotype()).evaluate() / (double)Data.getNumRows());
                        double geccoFit1 = 0.0;
                        double geccoFit2 = 0.0;
                        if (fitness instanceof GenericPareto) {
                            geccoFit1 = (double)((BooleanFunctionGenotype)individual.getGenotype()).evaluate1s() / (double)Data.getNum1Rows() / 3.0 + (double)((BooleanFunctionGenotype)individual.getGenotype()).evaluate0s() / (double)Data.getNum0Rows() / 3.0 + (double)(((GenericPareto)fitness).getPropertySizePruning() - length + 1) / (double)((GenericPareto)fitness).getPropertySizePruning().intValue() / 3.0;
                            geccoFit2 = (double)((BooleanFunctionGenotype)individual.getGenotype()).evaluate1s() / (double)Data.getNum1Rows() + (double)((BooleanFunctionGenotype)individual.getGenotype()).evaluate0s() / (double)Data.getNum0Rows() - (double)length / ((double)((GenericPareto)fitness).getPropertySizePruning().intValue() * (double)Data.getNumRows());
                        }
                        if (k == 0) {
                            RReturns.getAllMCRinTestData().add(new IndividualSummary(individual.getDateOfBirth(), length, mcr, ((BooleanFunctionGenotype)individual.getGenotype()).getCharacteristicBitSet(), Data.getResultBitSet(), Data.getNumRows(), geccoFit1, geccoFit2));
                            if (mcr < RReturns.getBestMCRinTestData()) {
                                RReturns.setBestMCRinTestData(mcr);
                            }
                        } else {
                            RReturns.getAllMCRinTrainingData().add(new IndividualSummary(individual.getDateOfBirth(), length, mcr, ((BooleanFunctionGenotype)individual.getGenotype()).getCharacteristicBitSet(), Data.getResultBitSet(), Data.getNumRows(), geccoFit1, geccoFit2));
                        }
                        s.append(String.valueOf(mcr) + " , ");
                    }
                    s.append(String.valueOf(this.getRunNumber()) + " , ");
                    s.append(String.valueOf(individual.getDateOfBirth()) + " , ");
                    s.append(String.valueOf(this.getNumberOfGenerations()) + " , ");
                    if (singleObjective) {
                        s.append(String.valueOf(((SingleObjectiveFitnessFunction)fitness).evaluate(individual, this.getBestIndividuals())) + " , ");
                    } else {
                        double[] result = ((MultiObjectiveFitnessFunction)fitness).evaluate(individual, this.getBestIndividuals());
                        int j = 0;
                        while (j < result.length) {
                            s.append(result[j]);
                            if (j < result.length - 1) {
                                s.append(" , ");
                            }
                            ++j;
                        }
                        s.append(" , ");
                    }
                    if (i.hasNext()) {
                        s.append(individual.getGenotype() + "\n");
                        continue;
                    }
                    s.append(individual.getGenotype());
                    if (runs != 2 || k != 0) continue;
                    s.append("\n");
                }
                ++k;
            }
            return s.toString();
        }

        public int getRunNumber() {
            return this.runNumber;
        }

        public void setRunNumber(int i) {
            this.runNumber = i;
        }

        public String getTestDataPath() {
            return this.testDataPath;
        }

        public void setTestDataPath(String testDataPath) {
            this.testDataPath = testDataPath;
        }
    }
}

