/*
 * Decompiled with CFR 0.152.
 */
package freak.core.modulesupport;

import freak.Freak;
import freak.core.graph.Initialization;
import java.lang.reflect.Method;

public class PropertyManager {
    public static String[] getListOfPropertyNames(Object obj) {
        String name;
        Method[] allMethods = obj.getClass().getMethods();
        int propCount = 0;
        int i = 0;
        while (i < allMethods.length) {
            name = allMethods[i].getName();
            if (name.length() > 11 && name.substring(0, 11).equals("getProperty") && !name.substring(11).equals("Type")) {
                ++propCount;
            }
            ++i;
        }
        String[] out = new String[propCount];
        int index = 0;
        int i2 = 0;
        while (i2 < allMethods.length) {
            name = allMethods[i2].getName();
            if (name.length() > 11 && name.substring(0, 11).equals("getProperty") && !name.substring(11).equals("Type")) {
                out[index++] = name.substring(11);
            }
            ++i2;
        }
        return out;
    }

    public static String[] getListOfPropertyNamesWithType(Object obj, Class type) {
        String[] allNames = PropertyManager.getListOfPropertyNames(obj);
        int count = 0;
        int i = 0;
        while (i < allNames.length) {
            if (PropertyManager.assignableFrom(PropertyManager.getPropertyType(obj, allNames[i]), type)) {
                ++count;
            }
            ++i;
        }
        String[] out = new String[count];
        int j = 0;
        int i2 = 0;
        while (i2 < allNames.length) {
            if (PropertyManager.assignableFrom(PropertyManager.getPropertyType(obj, allNames[i2]), type)) {
                out[j++] = allNames[i2];
            }
            ++i2;
        }
        return out;
    }

    public static boolean hasProperties(Object obj) {
        return PropertyManager.getListOfPropertyNames(obj).length > 0;
    }

    public static void setProperty(Object obj, String key, Object property) {
        try {
            Method m = PropertyManager.getSetterMethod(obj, key);
            Object[] args = new Object[]{property};
            m.invoke(obj, args);
        }
        catch (Exception e) {
            System.out.println("key=" + key + "; propType=" + property.getClass());
            throw new RuntimeException(e);
        }
    }

    public static Object getProperty(Object obj, String key) throws UnsupportedOperationException {
        Object ret = null;
        try {
            Method m = PropertyManager.getGetterMethod(obj, key);
            Object[] args = new Object[]{};
            ret = m.invoke(obj, args);
        }
        catch (Exception e) {
            int level = 3;
            if (obj instanceof Initialization) {
                level = 5;
            }
            Freak.debug("Exception in PropertyManager.getProperty: object=" + obj + ", key=" + key, level);
            throw new UnsupportedOperationException();
        }
        return ret;
    }

    public static Class getPropertyType(Object obj, String key) {
        Class<?> objClass = obj.getClass();
        Class[] abstractArgs = new Class[]{};
        Method m = null;
        try {
            m = objClass.getMethod("getProperty" + key, abstractArgs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Class<?> returnType = m.getReturnType();
        return returnType;
    }

    public static String getShortDescriptionFor(Object obj, String property) {
        Method m = PropertyManager.getGetShortDescriptionForMethod(obj, property);
        String s = null;
        if (m != null) {
            try {
                Object[] args = new Object[]{};
                s = (String)m.invoke(obj, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            s = property;
        }
        return s;
    }

    public static String getLongDescriptionFor(Object obj, String property) {
        Method m = PropertyManager.getGetLongDescriptionForMethod(obj, property);
        String s = null;
        if (m != null) {
            try {
                Object[] args = new Object[]{};
                s = (String)m.invoke(obj, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            s = "";
        }
        return s;
    }

    public static Method getGetShortDescriptionForMethod(Object obj, String property) {
        String methodName = "getShortDescriptionFor" + property;
        Method m = null;
        try {
            m = obj.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return m;
    }

    public static Method getGetLongDescriptionForMethod(Object obj, String property) {
        String methodName = "getLongDescriptionFor" + property;
        Method m = null;
        try {
            m = obj.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            m = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return m;
    }

    public static Method getGetterMethod(Object obj, String property) throws NoSuchMethodException {
        String methodName = "getProperty" + property;
        return obj.getClass().getMethod(methodName, new Class[0]);
    }

    public static Method getSetterMethod(Object obj, String property) throws NoSuchMethodException {
        String methodName = "setProperty" + property;
        Class propType = PropertyManager.getPropertyType(obj, property);
        return obj.getClass().getMethod(methodName, propType);
    }

    public static boolean assignableFrom(Class c1, Class c2) {
        return c1.isAssignableFrom(c2);
    }

    public static boolean classesOfObjectsMatch(Object o1, Object o2) {
        return PropertyManager.assignableFrom(o1.getClass(), o2.getClass());
    }
}

