/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.selection.booleanfunction;

import freak.core.control.Schedule;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Selection;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.module.searchspace.BooleanFunctionGenotype;

public class PopulationSelection
extends Selection
implements Configurable {
    private int noOfPopulation = 0;

    public PopulationSelection(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addOutPort();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
    }

    public IndividualList[] process(IndividualList[] original) {
        if (original[0].size() == 0) {
            IndividualList[] result = new IndividualList[]{new Population(this.getOperatorGraph().getSchedule())};
            return result;
        }
        IndividualList[] result = new IndividualList[1];
        Individual[] origin = original[0].toArray();
        result[0] = new Population(this.graph.getSchedule());
        int i = 0;
        while (i < origin.length) {
            BooleanFunctionGenotype bfg = (BooleanFunctionGenotype)origin[i].getGenotype();
            if (bfg.getPopulation() == this.noOfPopulation) {
                result[0].addIndividual(origin[i]);
            }
            ++i;
        }
        return result;
    }

    public Integer getPropertyNoOfPopulation() {
        return new Integer(this.noOfPopulation);
    }

    public void setPropertyNoOfPopulation(Integer noOfPopulation) {
        this.noOfPopulation = noOfPopulation;
    }

    public String getShortDescriptionForNoOfPopulation() {
        return "Selected Population";
    }

    public String getLongDescriptionForNoOfPopulation() {
        return "All individuals of this population will be returned.";
    }

    public String getName() {
        return "PopulationSelection";
    }

    public String getDescription() {
        return "Selects all individuals from the specified population.";
    }
}

