% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{.postAR1}
\alias{.postAR1}
\title{Draws from the posterior the autoregressive parameter of a stationary AR(1) process
without starting values.}
\usage{
.postAR1(Y, phi, phi0, Q0, sigma, lb = -Inf, ub = Inf)
}
\arguments{
\item{Y}{a \code{Tn x 1} vector.}

\item{phi}{a scalar containing the last draw of the autoregressive parameter \eqn{\phi}.}

\item{phi0}{a scalar containing the prior mean for \code{phi}.}

\item{Q0}{a scalar containing the prior precision for \code{phi}.}

\item{sigma}{a scalar containing the innovation variance.}

\item{lb}{(optional) lower bound for \code{phi}.}

\item{ub}{(optional) upper bound for \code{phi}.}
}
\description{
Draws from the posterior the autoregressive parameter of a stationary AR(1) process
without starting values.
}
\details{
The corresponding model is given by \eqn{Y_t = \phi Y_{t-1} + e_t}, where
  \eqn{e_t ~ N(0, \sigma)} with prior distribution
  \eqn{p(\phi) = N(\phi_0, 1/Q_0 )}.

Conditional on the variance \eqn{\sigma}, the posterior is normal and known.

Stationarity and box constraints are enforced. If the stationarity constraint
  is not fulfilled, the last draw is returned.
}
\keyword{internal}
