% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotSSprediction}
\alias{plotSSprediction}
\title{Plots the trend series and the (fitted) second observation equation and gives diagnostic
plots based on standardized residuals.}
\usage{
plotSSprediction(
  tsl,
  legend,
  title,
  n.ahead,
  boundName,
  res = NULL,
  namesPrint,
  bounds,
  combine,
  path,
  device,
  width,
  height
)
}
\arguments{
\item{tsl}{A list with two multiple time series objects for the first and second plor,
respectively.}

\item{legend}{A list with two character vectors. The first contains the legend names for
the first plot and so on.}

\item{title}{A list with the titles for the first three plots.}

\item{n.ahead}{Integer indicating the forecast horizon.}

\item{boundName}{The legend name of the confidence bounds.}

\item{res}{The residual series as time series. If \code{res = NULL}, all graphs realted
to the residual series will not be plotted.}

\item{namesPrint}{A character vector containing two names for the first two plots. The
remaining names are creates automatically if \code{combine = FALSE}.}

\item{bounds}{A logical indicating whether significance intervals should be plotted around
the nawru. The default is \code{bounds = TRUE}.}

\item{combine}{A logical indicating whether the diagnostic plots should be combined or not,
the default is \code{TRUE}.}

\item{path}{An optional file path. If specified, the plots will be saved using the format
in \code{device} under the given path.}

\item{device}{Device passed on to \code{ggplot} for plot saving. Options are 
\code{"eps", "ps", "tex"} (pictex), \code{"pdf", "jpeg", "tiff", "png", "bmp", "svg"} 
or \code{"wmf"}.}

\item{width}{The plot width in case of printing.}

\item{height}{The plot height in case of printing.}
}
\description{
Plots the trend series and the (fitted) second observation equation and gives diagnostic
plots based on standardized residuals.
}
\keyword{internal}
