% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modDownload.R
\name{modDownload}
\alias{modDownload}
\title{Search and download MODIS images}
\usage{
modDownload(product, startDate, endDate, username, password, AppRoot,
  collection = 6, nattempts = 5, verbose = FALSE,
  extract.tif = FALSE, ...)
}
\arguments{
\item{product}{a \code{character} argument with the short name of the MODIS
product.}

\item{startDate}{a \code{Date} class object with the starting date of the 
study period.}

\item{endDate}{a \code{Date} class object with the ending date of the 
study period.}

\item{username}{NASA's `EarthData' username.}

\item{password}{NASA's `EarthData' password.}

\item{AppRoot}{the directory to save the outcoming time series.}

\item{collection}{MODIS collection, by default 6.}

\item{nattempts}{the number of attempts to download an image in case it
becomes corrupted.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints running stages and warnings.}

\item{extract.tif}{logical argument. If \code{TRUE}, extracts all the layers
from hdf files and saves them as GTiff.}

\item{...}{arguments for nested functions:
\itemize{
  \item \code{lonlat} a vector with the longitude/latitude
  coordinates of the point of interest. This argument is mandatory if
  \code{polygon} or \code{extent} are not defined.
  \item \code{extent} an \code{extent}, \code{Raster*}, or \code{Spatial*}
  object representing the region of interest with longitude/latitude
  coordinates. This argument is mandatory if \code{polygon} or \code{lonlat}
  are not defined.
  \item \code{polygon} A list of vectors defining the points of a polygon in
  longitude/latitude format. This argument is mandatory if \code{lonlat} or
  \code{extent} are not defined.
  \item Any argument in \code{\link{modExtractHDF}} function. Ex.
  \code{bFilter="b01_1"}.
}}
}
\description{
\code{modDownload} searches and downloads MODIS images concerning a particular
location and time interval from the `EarthData' repository. Images are
saved as GTiff files in the \code{AppRoot} directory.
}
\details{
\code{modDownload} uses the 
\href{https://lpdaacsvc.cr.usgs.gov/services/inventory}{NASA’s Common Metadata Repository}
to search and the
\href{https://earthdata.nasa.gov/}{`EarthData' web service}
to download the imagery. The catalogue of MODIS products can be found
\href{https://modis.gsfc.nasa.gov/data/dataprod/}{here}.
The catalogue shows detailed information about the products and their short
names. By the time `RGISTools' is released, NASA carries out the maintenance
of its website on Wednesdays, which may cause an error when connecting to
their server. You can get your `EarthData' credentials
\href{https://urs.earthdata.nasa.gov/users/new}{here}.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
src <- paste0(tempdir(),"/Path_for_downloading_folder")
print(src)
modDownload(product = "MOD09GA",
            startDate = as.Date("01-01-2018", "\%d-\%m-\%Y"),
            endDate = as.Date("03-01-2018", "\%d-\%m-\%Y"),
            username = "username",
            password = "password",
            AppRoot = src,
            extract.tif = TRUE,
            collection = 6,
            extent = ex.navarre)
tif.src <- file.path(src,"Modis","MOD09GA","tif")
files <- list.files(tif.src,
                    pattern = "\\\\.tif$",
                    full.names = TRUE,
                    recursive = TRUE)[c(16,19,18)]
files.stack <- stack(files)
qrange <- c(0.001, 0.999)
imagen <- varRGB(files.stack[[1]], 
                 files.stack[[2]],
                 files.stack[[3]],
                 qrange)
plotRGB(imagen)
}
}
